/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import org.spearce.jgit.lib.ByteWindow;
import org.spearce.jgit.lib.UnpackedObjectCache;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.lib.WindowedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowCache {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static int maxByteCount = 0xA00000;
    private static int windowSize;
    private static int windowSizeShift;
    static boolean mmap;
    static final ReferenceQueue<?> clearedWindowQueue;
    private static ByteWindow[] cache;
    private static ByteWindow lruHead;
    private static ByteWindow lruTail;
    private static int openByteCount;
    private static int hits;
    private static int reqs;
    private static int opens;
    private static int closes;

    private static final int bits(int newSize) {
        if (newSize < 4096) {
            throw new IllegalArgumentException("Invalid window size");
        }
        if (Integer.bitCount(newSize) != 1) {
            throw new IllegalArgumentException("Window size must be power of 2");
        }
        return Integer.numberOfTrailingZeros(newSize);
    }

    /*
     * WARNING - void declaration
     */
    static synchronized String statString() {
        int maxChain = 0;
        int tot = 0;
        for (ByteWindow byteWindow : cache) {
            void var5_5;
            int n = 0;
            while (var5_5 != null) {
                ++n;
                ++tot;
                ByteWindow<?> byteWindow2 = var5_5.chainNext;
            }
            maxChain = Math.max(maxChain, n);
        }
        return "WindowCache[ hits: " + hits * 100 / reqs + "%" + "; windows: " + tot + " maxChain: " + maxChain + "; kb:" + openByteCount / 1024 + "; cache: " + cache.length + " fds: " + (opens - closes) + "," + opens + "," + closes + " ]";
    }

    private static int cacheTableSize() {
        return 5 * (maxByteCount / windowSize) / 2;
    }

    public static void reconfigure(int packedGitLimit, int packedGitWindowSize, boolean packedGitMMAP, int deltaBaseCacheLimit) {
        WindowCache.reconfigureImpl(packedGitLimit, packedGitWindowSize, packedGitMMAP);
        UnpackedObjectCache.reconfigure(deltaBaseCacheLimit);
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void reconfigureImpl(int packedGitLimit, int packedGitWindowSize, boolean packedGitMMAP) {
        boolean prune = false;
        boolean evictAll = false;
        if (maxByteCount < packedGitLimit) {
            maxByteCount = packedGitLimit;
        } else if (maxByteCount > packedGitLimit) {
            maxByteCount = packedGitLimit;
            prune = true;
        }
        if (WindowCache.bits(packedGitWindowSize) != windowSizeShift) {
            windowSizeShift = WindowCache.bits(packedGitWindowSize);
            windowSize = 1 << windowSizeShift;
            evictAll = true;
        }
        if (mmap != packedGitMMAP) {
            mmap = packedGitMMAP;
            evictAll = true;
        }
        if (evictAll) {
            for (ByteWindow byteWindow : cache) {
                void var8_11;
                while (var8_11 != null) {
                    WindowCache.clear(var8_11);
                    ByteWindow<?> byteWindow2 = var8_11.chainNext;
                }
            }
            WindowCache.runClearedWindowQueue();
            cache = new ByteWindow[WindowCache.cacheTableSize()];
        } else {
            if (prune) {
                WindowCache.releaseMemory();
                WindowCache.runClearedWindowQueue();
            }
            if (cache.length != WindowCache.cacheTableSize()) {
                void var8_15;
                ByteWindow[] priorTable = cache;
                cache = new ByteWindow[WindowCache.cacheTableSize()];
                ByteWindow[] arr$ = priorTable;
                int len$ = arr$.length;
                boolean bl = false;
                while (var8_15 < len$) {
                    void var9_16;
                    ByteWindow byteWindow = arr$[var8_15];
                    while (var9_16 != null) {
                        ByteWindow<?> n = var9_16.chainNext;
                        int idx = WindowCache.hash(var9_16.provider, var9_16.id);
                        var9_16.chainNext = cache[idx];
                        WindowCache.cache[idx] = var9_16;
                        ByteWindow<?> byteWindow3 = n;
                    }
                    ++var8_15;
                }
            }
        }
    }

    public static final synchronized void get(WindowCursor curs, WindowedFile wp, long position) throws IOException {
        ++reqs;
        int id = (int)(position >> windowSizeShift);
        int idx = WindowCache.hash(wp, id);
        ByteWindow<?> e = cache[idx];
        while (e != null) {
            if (e.provider == wp && e.id == id) {
                curs.handle = e.get();
                if (curs.handle != null) {
                    curs.window = e;
                    WindowCache.makeMostRecent(e);
                    ++hits;
                    return;
                }
                WindowCache.clear(e);
                break;
            }
            e = e.chainNext;
        }
        if (wp.openCount == 0) {
            try {
                ++opens;
                wp.openCount = 1;
                wp.cacheOpen();
            }
            catch (IOException ioe) {
                wp.openCount = 0;
                throw ioe;
            }
            catch (RuntimeException ioe) {
                wp.openCount = 0;
                throw ioe;
            }
            catch (Error ioe) {
                wp.openCount = 0;
                throw ioe;
            }
            finally {
                --wp.openCount;
            }
            e = cache[idx];
            while (e != null) {
                if (e.provider == wp && e.id == id) {
                    curs.handle = e.get();
                    if (curs.handle != null) {
                        curs.window = e;
                        WindowCache.makeMostRecent(e);
                        return;
                    }
                    WindowCache.clear(e);
                    break;
                }
                e = e.chainNext;
            }
        }
        int wsz = WindowCache.windowSize(wp, id);
        ++wp.openCount;
        openByteCount += wsz;
        WindowCache.releaseMemory();
        WindowCache.runClearedWindowQueue();
        wp.allocWindow(curs, id, id << windowSizeShift, wsz);
        ByteWindow e2 = curs.window;
        e2.chainNext = cache[idx];
        WindowCache.cache[idx] = e2;
        WindowCache.insertLRU(e2);
    }

    private static void makeMostRecent(ByteWindow<?> e) {
        if (lruHead != e) {
            WindowCache.unlinkLRU(e);
            WindowCache.insertLRU(e);
        }
    }

    private static void releaseMemory() {
        ByteWindow<?> e = lruTail;
        while (openByteCount > maxByteCount && e != null) {
            ByteWindow<?> p = e.lruPrev;
            WindowCache.clear(e);
            e = p;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final synchronized void purge(WindowedFile wp) {
        for (ByteWindow byteWindow : cache) {
            void var4_4;
            while (var4_4 != null) {
                if (var4_4.provider == wp) {
                    WindowCache.clear(var4_4);
                }
                ByteWindow<?> byteWindow2 = var4_4.chainNext;
            }
        }
        WindowCache.runClearedWindowQueue();
    }

    private static void runClearedWindowQueue() {
        ByteWindow e;
        while ((e = (ByteWindow)clearedWindowQueue.poll()) != null) {
            WindowCache.unlinkSize(e);
            WindowCache.unlinkLRU(e);
            WindowCache.unlinkCache(e);
            e.chainNext = null;
            e.lruNext = null;
            e.lruPrev = null;
        }
    }

    private static void clear(ByteWindow<?> e) {
        WindowCache.unlinkSize(e);
        e.clear();
        e.enqueue();
    }

    private static void unlinkSize(ByteWindow<?> e) {
        if (e.sizeActive) {
            if (--e.provider.openCount == 0) {
                ++closes;
                e.provider.cacheClose();
            }
            openByteCount -= e.size;
            e.sizeActive = false;
        }
    }

    private static void unlinkCache(ByteWindow dead) {
        int idx = WindowCache.hash(dead.provider, dead.id);
        ByteWindow<?> e = cache[idx];
        ByteWindow<?> p = null;
        while (e != null) {
            ByteWindow<?> n = e.chainNext;
            if (e == dead) {
                if (p == null) {
                    WindowCache.cache[idx] = n;
                    break;
                }
                p.chainNext = n;
                break;
            }
            p = e;
            e = n;
        }
    }

    private static void unlinkLRU(ByteWindow e) {
        ByteWindow<?> prev = e.lruPrev;
        ByteWindow<?> next = e.lruNext;
        if (prev != null) {
            prev.lruNext = next;
        } else {
            lruHead = next;
        }
        if (next != null) {
            next.lruPrev = prev;
        } else {
            lruTail = prev;
        }
    }

    private static void insertLRU(ByteWindow<?> e) {
        ByteWindow h = lruHead;
        e.lruPrev = null;
        e.lruNext = h;
        if (h != null) {
            h.lruPrev = e;
        } else {
            lruTail = e;
        }
        lruHead = e;
    }

    private static int hash(WindowedFile wp, int id) {
        return (wp.hash + id >>> 1) % cache.length;
    }

    private static int windowSize(WindowedFile file, int id) {
        long pos;
        long len = file.length();
        return len < (pos = (long)(id << windowSizeShift)) + (long)windowSize ? (int)(len - pos) : windowSize;
    }

    private WindowCache() {
        throw new UnsupportedOperationException();
    }

    static {
        windowSizeShift = WindowCache.bits(8192);
        windowSize = 1 << windowSizeShift;
        mmap = false;
        cache = new ByteWindow[WindowCache.cacheTableSize()];
        clearedWindowQueue = new ReferenceQueue();
    }
}

