/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.spearce.jgit.lib.ByteWindow;
import org.spearce.jgit.lib.InflaterCache;
import org.spearce.jgit.lib.WindowCache;
import org.spearce.jgit.lib.WindowedFile;

public final class WindowCursor {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    ByteWindow window;
    Object handle;

    int copy(WindowedFile provider, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        int need;
        int r;
        long length = provider.length();
        for (need = cnt; need > 0 && position < length; need -= r) {
            this.pin(provider, position);
            r = this.window.copy(this.handle, position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
        }
        return cnt - need;
    }

    int inflate(WindowedFile provider, long position, byte[] dstbuf, int dstoff) throws IOException, DataFormatException {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
        while (true) {
            this.pin(provider, position);
            dstoff = this.window.inflate(this.handle, position, dstbuf, dstoff, this.inf);
            if (this.inf.finished()) {
                return dstoff;
            }
            position = this.window.end;
        }
    }

    void inflateVerify(WindowedFile provider, long position) throws IOException, DataFormatException {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
        while (true) {
            this.pin(provider, position);
            this.window.inflateVerify(this.handle, position, this.inf);
            if (this.inf.finished()) {
                return;
            }
            position = this.window.end;
        }
    }

    private void pin(WindowedFile provider, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(provider, position)) {
            WindowCache.get(this, provider, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.window = null;
        this.handle = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    public static WindowCursor release(WindowCursor curs) {
        if (curs != null) {
            curs.release();
        }
        return null;
    }
}

