/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.DataFormatException;
import org.spearce.jgit.lib.ByteArrayWindow;
import org.spearce.jgit.lib.ByteBufferWindow;
import org.spearce.jgit.lib.WindowCache;
import org.spearce.jgit.lib.WindowCursor;

public class WindowedFile {
    private final File fPath;
    final int hash;
    RandomAccessFile fd;
    private long length;
    int openCount;

    public WindowedFile(File file) {
        this.fPath = file;
        this.hash = System.identityHashCode(this) * 31;
        this.length = Long.MAX_VALUE;
    }

    public long length() {
        return this.length;
    }

    public File getFile() {
        return this.fPath.getAbsoluteFile();
    }

    public String getName() {
        return this.getFile().getPath();
    }

    public int read(long position, byte[] dstbuf, WindowCursor curs) throws IOException {
        return this.read(position, dstbuf, 0, dstbuf.length, curs);
    }

    public int read(long position, byte[] dstbuf, int dstoff, int cnt, WindowCursor curs) throws IOException {
        return curs.copy(this, position, dstbuf, dstoff, cnt);
    }

    public void readFully(long position, byte[] dstbuf, WindowCursor curs) throws IOException {
        if (this.read(position, dstbuf, 0, dstbuf.length, curs) != dstbuf.length) {
            throw new EOFException();
        }
    }

    public void copyToStream(long position, byte[] buf, long cnt, OutputStream out, WindowCursor curs) throws IOException, EOFException {
        while (cnt > 0L) {
            int toRead = (int)Math.min(cnt, (long)buf.length);
            int read = this.read(position, buf, 0, toRead, curs);
            if (read != toRead) {
                throw new EOFException();
            }
            position += (long)read;
            cnt -= (long)read;
            out.write(buf, 0, read);
        }
    }

    void readCompressed(long position, byte[] dstbuf, WindowCursor curs) throws IOException, DataFormatException {
        if (curs.inflate(this, position, dstbuf, 0) != dstbuf.length) {
            throw new EOFException("Short compressed stream at " + position);
        }
    }

    void verifyCompressed(long position, WindowCursor curs) throws IOException, DataFormatException {
        curs.inflateVerify(this, position);
    }

    protected void onOpen() throws IOException {
    }

    public void close() {
        WindowCache.purge(this);
    }

    void cacheOpen() throws IOException {
        this.fd = new RandomAccessFile(this.fPath, "r");
        this.length = this.fd.length();
        try {
            this.onOpen();
        }
        catch (IOException ioe) {
            this.cacheClose();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.cacheClose();
            throw re;
        }
        catch (Error re) {
            this.cacheClose();
            throw re;
        }
    }

    void cacheClose() {
        try {
            this.fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fd = null;
    }

    void allocWindow(WindowCursor curs, int windowId, long pos, int size) {
        if (WindowCache.mmap) {
            MappedByteBuffer map;
            try {
                map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
            }
            catch (IOException e) {
                try {
                    curs.release();
                    System.gc();
                    System.runFinalization();
                    map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
                }
                catch (IOException ioe2) {
                    map = null;
                    System.err.println("warning: mmap failure: " + ioe2);
                }
            }
            if (map != null) {
                if (map.hasArray()) {
                    byte[] b = map.array();
                    ByteArrayWindow w = new ByteArrayWindow(this, pos, windowId, b);
                    w.loaded = true;
                    curs.window = w;
                    curs.handle = b;
                } else {
                    curs.window = new ByteBufferWindow(this, pos, windowId, map);
                    curs.handle = map;
                }
                return;
            }
        }
        byte[] b = new byte[size];
        curs.window = new ByteArrayWindow(this, pos, windowId, b);
        curs.handle = b;
    }
}

