/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.merge;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectWriter;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevTree;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;
import org.spearce.jgit.treewalk.AbstractTreeIterator;
import org.spearce.jgit.treewalk.CanonicalTreeParser;
import org.spearce.jgit.treewalk.EmptyTreeIterator;

public abstract class Merger {
    protected final Repository db;
    protected final RevWalk walk;
    private ObjectWriter writer;
    protected RevObject[] sourceObjects;
    protected RevCommit[] sourceCommits;
    protected RevTree[] sourceTrees;

    protected Merger(Repository local) {
        this.db = local;
        this.walk = new RevWalk(this.db);
    }

    public Repository getRepository() {
        return this.db;
    }

    public ObjectWriter getObjectWriter() {
        if (this.writer == null) {
            this.writer = new ObjectWriter(this.getRepository());
        }
        return this.writer;
    }

    public final boolean merge(AnyObjectId[] tips) throws IOException {
        int i;
        this.sourceObjects = new RevObject[tips.length];
        for (i = 0; i < tips.length; ++i) {
            this.sourceObjects[i] = this.walk.parseAny(tips[i]);
        }
        this.sourceCommits = new RevCommit[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            try {
                this.sourceCommits[i] = this.walk.parseCommit(this.sourceObjects[i]);
                continue;
            }
            catch (IncorrectObjectTypeException err) {
                this.sourceCommits[i] = null;
            }
        }
        this.sourceTrees = new RevTree[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            this.sourceTrees[i] = this.walk.parseTree(this.sourceObjects[i]);
        }
        return this.mergeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractTreeIterator mergeBase(int aIdx, int bIdx) throws IOException {
        if (this.sourceCommits[aIdx] == null) {
            throw new IncorrectObjectTypeException(this.sourceObjects[aIdx], "commit");
        }
        if (this.sourceCommits[bIdx] == null) {
            throw new IncorrectObjectTypeException(this.sourceObjects[bIdx], "commit");
        }
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(this.sourceCommits[aIdx]);
        this.walk.markStart(this.sourceCommits[bIdx]);
        RevCommit base = this.walk.next();
        if (base == null) {
            return new EmptyTreeIterator();
        }
        RevCommit base2 = this.walk.next();
        if (base2 != null) {
            throw new IOException("Multiple merge bases for:\n  " + this.sourceCommits[aIdx].name() + "\n  " + this.sourceCommits[bIdx].name() + "found:" + "\n  " + base.name() + "\n  " + base2.name());
        }
        WindowCursor curs = new WindowCursor();
        try {
            CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser(null, this.db, base.getTree(), curs);
            return canonicalTreeParser;
        }
        finally {
            curs.release();
        }
    }

    protected abstract boolean mergeImpl() throws IOException;

    public abstract ObjectId getResultTreeId();
}

