/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.merge;

import java.io.IOException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.merge.MergeStrategy;
import org.spearce.jgit.merge.Merger;

public class StrategyOneSided
extends MergeStrategy {
    private final String strategyName;
    private final int treeIndex;

    protected StrategyOneSided(String name, int index) {
        this.strategyName = name;
        this.treeIndex = index;
    }

    public String getName() {
        return this.strategyName;
    }

    public Merger newMerger(Repository db) {
        return new OneSide(db, this.treeIndex);
    }

    protected static class OneSide
    extends Merger {
        private final int treeIndex;

        protected OneSide(Repository local, int index) {
            super(local);
            this.treeIndex = index;
        }

        protected boolean mergeImpl() throws IOException {
            return this.treeIndex < this.sourceTrees.length;
        }

        public ObjectId getResultTreeId() {
            return this.sourceTrees[this.treeIndex];
        }
    }
}

