/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.merge;

import java.io.IOException;
import org.spearce.jgit.dircache.DirCache;
import org.spearce.jgit.dircache.DirCacheBuilder;
import org.spearce.jgit.dircache.DirCacheEntry;
import org.spearce.jgit.errors.UnmergedPathException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.merge.MergeStrategy;
import org.spearce.jgit.merge.Merger;
import org.spearce.jgit.treewalk.AbstractTreeIterator;
import org.spearce.jgit.treewalk.NameConflictTreeWalk;

public class StrategySimpleTwoWayInCore
extends MergeStrategy {
    static final MergeStrategy INSTANCE = new StrategySimpleTwoWayInCore();

    protected StrategySimpleTwoWayInCore() {
    }

    public String getName() {
        return "simple-two-way-in-core";
    }

    public Merger newMerger(Repository db) {
        return new InCoreMerger(db);
    }

    private static class InCoreMerger
    extends Merger {
        private static final int T_BASE = 0;
        private static final int T_OURS = 1;
        private static final int T_THEIRS = 2;
        private final NameConflictTreeWalk tw;
        private final DirCache cache;
        private DirCacheBuilder builder;
        private ObjectId resultTree;

        InCoreMerger(Repository local) {
            super(local);
            this.tw = new NameConflictTreeWalk(this.db);
            this.cache = DirCache.newInCore();
        }

        protected boolean mergeImpl() throws IOException {
            if (this.sourceTrees.length != 2) {
                return false;
            }
            this.tw.reset();
            this.tw.addTree(this.mergeBase(0, 1));
            this.tw.addTree(this.sourceTrees[0]);
            this.tw.addTree(this.sourceTrees[1]);
            boolean hasConflict = false;
            this.builder = this.cache.builder();
            while (this.tw.next()) {
                int modeT;
                int modeO = this.tw.getRawMode(1);
                if (modeO == (modeT = this.tw.getRawMode(2)) && this.tw.idEqual(1, 2)) {
                    this.same();
                    continue;
                }
                int modeB = this.tw.getRawMode(0);
                if (modeB == modeO && this.tw.idEqual(0, 1)) {
                    this.add(2, 0);
                    continue;
                }
                if (modeB == modeT && this.tw.idEqual(0, 2)) {
                    this.add(1, 0);
                    continue;
                }
                this.conflict();
                hasConflict = true;
            }
            this.builder.finish();
            this.builder = null;
            if (hasConflict) {
                return false;
            }
            try {
                this.resultTree = this.cache.writeTree(this.getObjectWriter());
                return true;
            }
            catch (UnmergedPathException upe) {
                this.resultTree = null;
                return false;
            }
        }

        private void same() throws IOException {
            if (this.tw.isSubtree()) {
                this.builder.addTree(this.tw.getRawPath(), this.db, this.tw.getObjectId(1));
            } else {
                this.add(1, 0);
            }
        }

        private void conflict() {
            this.add(0, 1);
            this.add(1, 2);
            this.add(2, 3);
        }

        private void add(int tree, int stage) {
            AbstractTreeIterator i = this.getTree(tree);
            if (i != null) {
                DirCacheEntry e = new DirCacheEntry(this.tw.getRawPath(), stage);
                e.setObjectIdFromRaw(i.idBuffer(), i.idOffset());
                e.setFileMode(this.tw.getFileMode(tree));
                this.builder.add(e);
            }
        }

        private AbstractTreeIterator getTree(int tree) {
            return this.tw.getTree(tree, AbstractTreeIterator.class);
        }

        public ObjectId getResultTreeId() {
            return this.resultTree;
        }
    }
}

