/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.patch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.patch.BinaryHunk;
import org.spearce.jgit.patch.CombinedFileHeader;
import org.spearce.jgit.patch.FileHeader;
import org.spearce.jgit.patch.FormatError;
import org.spearce.jgit.patch.HunkHeader;
import org.spearce.jgit.util.RawParseUtils;
import org.spearce.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch {
    private static final byte[] DIFF_GIT = Constants.encodeASCII("diff --git ");
    private static final byte[] DIFF_CC = Constants.encodeASCII("diff --cc ");
    private static final byte[] DIFF_COMBINED = Constants.encodeASCII("diff --combined ");
    private static final byte[][] BIN_HEADERS = new byte[][]{Constants.encodeASCII("Binary files "), Constants.encodeASCII("Files ")};
    private static final byte[] BIN_TRAILER = Constants.encodeASCII(" differ\n");
    private static final byte[] GIT_BINARY = Constants.encodeASCII("GIT binary patch\n");
    static final byte[] SIG_FOOTER = Constants.encodeASCII("-- \n");
    private final List<FileHeader> files = new ArrayList<FileHeader>();
    private final List<FormatError> errors = new ArrayList<FormatError>(0);

    public void addFile(FileHeader fh) {
        this.files.add(fh);
    }

    public List<? extends FileHeader> getFiles() {
        return this.files;
    }

    public void addError(FormatError err) {
        this.errors.add(err);
    }

    public List<FormatError> getErrors() {
        return this.errors;
    }

    public void parse(InputStream is) throws IOException {
        byte[] buf = Patch.readFully(is);
        this.parse(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFully(InputStream is) throws IOException {
        TemporaryBuffer b = new TemporaryBuffer();
        try {
            b.copy(is);
            b.close();
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        finally {
            b.destroy();
        }
    }

    public void parse(byte[] buf, int ptr, int end) {
        while (ptr < end) {
            ptr = this.parseFile(buf, ptr, end);
        }
    }

    private int parseFile(byte[] buf, int c, int end) {
        while (c < end) {
            if (FileHeader.isHunkHdr(buf, c, end) >= 1) {
                this.error(buf, c, "Hunk disconnected from file");
                c = RawParseUtils.nextLF(buf, c);
                continue;
            }
            if (RawParseUtils.match(buf, c, DIFF_GIT) >= 0) {
                return this.parseDiffGit(buf, c, end);
            }
            if (RawParseUtils.match(buf, c, DIFF_CC) >= 0) {
                return this.parseDiffCombined(DIFF_CC, buf, c, end);
            }
            if (RawParseUtils.match(buf, c, DIFF_COMBINED) >= 0) {
                return this.parseDiffCombined(DIFF_COMBINED, buf, c, end);
            }
            int n = RawParseUtils.nextLF(buf, c);
            if (n >= end) {
                return end;
            }
            if (n - c < 6) {
                c = n;
                continue;
            }
            if (RawParseUtils.match(buf, c, FileHeader.OLD_NAME) >= 0 && RawParseUtils.match(buf, n, FileHeader.NEW_NAME) >= 0) {
                int f = RawParseUtils.nextLF(buf, n);
                if (f >= end) {
                    return end;
                }
                if (FileHeader.isHunkHdr(buf, f, end) == 1) {
                    return this.parseTraditionalPatch(buf, c, end);
                }
            }
            c = n;
        }
        return c;
    }

    private int parseDiffGit(byte[] buf, int start, int end) {
        FileHeader fh = new FileHeader(buf, start);
        int ptr = fh.parseGitFileName(start + DIFF_GIT.length, end);
        if (ptr < 0) {
            return Patch.skipFile(buf, start, end);
        }
        ptr = fh.parseGitHeaders(ptr, end);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end);
        this.addFile(fh);
        return ptr;
    }

    private int parseDiffCombined(byte[] hdr, byte[] buf, int start, int end) {
        CombinedFileHeader fh = new CombinedFileHeader(buf, start);
        int ptr = fh.parseGitFileName(start + hdr.length, end);
        if (ptr < 0) {
            return Patch.skipFile(buf, start, end);
        }
        ptr = fh.parseGitHeaders(ptr, end);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end);
        this.addFile(fh);
        return ptr;
    }

    private int parseTraditionalPatch(byte[] buf, int start, int end) {
        FileHeader fh = new FileHeader(buf, start);
        int ptr = fh.parseTraditionalHeaders(start, end);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end);
        this.addFile(fh);
        return ptr;
    }

    private static int skipFile(byte[] buf, int ptr, int end) {
        if (RawParseUtils.match(buf, ptr = RawParseUtils.nextLF(buf, ptr), FileHeader.OLD_NAME) >= 0) {
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        return ptr;
    }

    private int parseHunks(FileHeader fh, int c, int end) {
        byte[] buf = fh.buf;
        block3: while (c < end && RawParseUtils.match(buf, c, DIFF_GIT) < 0 && RawParseUtils.match(buf, c, DIFF_CC) < 0 && RawParseUtils.match(buf, c, DIFF_COMBINED) < 0 && RawParseUtils.match(buf, c, FileHeader.OLD_NAME) < 0 && RawParseUtils.match(buf, c, FileHeader.NEW_NAME) < 0) {
            if (FileHeader.isHunkHdr(buf, c, end) == fh.getParentCount()) {
                HunkHeader h = fh.newHunkHeader(c);
                h.parseHeader(end);
                h.endOffset = c = h.parseBody(this, end);
                fh.addHunk(h);
                if (c >= end) continue;
                switch (buf[c]) {
                    case 10: 
                    case 64: 
                    case 100: {
                        continue block3;
                    }
                }
                if (RawParseUtils.match(buf, c, SIG_FOOTER) >= 0) continue;
                this.warn(buf, c, "Unexpected hunk trailer");
                continue;
            }
            int eol = RawParseUtils.nextLF(buf, c);
            if (fh.getHunks().isEmpty() && RawParseUtils.match(buf, c, GIT_BINARY) >= 0) {
                fh.patchType = FileHeader.PatchType.GIT_BINARY;
                return this.parseGitBinary(fh, eol, end);
            }
            if (fh.getHunks().isEmpty() && BIN_TRAILER.length < eol - c && RawParseUtils.match(buf, eol - BIN_TRAILER.length, BIN_TRAILER) >= 0 && Patch.matchAny(buf, c, BIN_HEADERS)) {
                fh.patchType = FileHeader.PatchType.BINARY;
                return eol;
            }
            c = eol;
        }
        if (fh.getHunks().isEmpty() && fh.getPatchType() == FileHeader.PatchType.UNIFIED && !fh.hasMetaDataChanges()) {
            fh.patchType = FileHeader.PatchType.BINARY;
        }
        return c;
    }

    private int parseGitBinary(FileHeader fh, int c, int end) {
        BinaryHunk postImage = new BinaryHunk(fh, c);
        int nEnd = postImage.parseHunk(c, end);
        if (nEnd < 0) {
            this.error(fh.buf, c, "Missing forward-image in GIT binary patch");
            return c;
        }
        postImage.endOffset = c = nEnd;
        fh.forwardBinaryHunk = postImage;
        BinaryHunk preImage = new BinaryHunk(fh, c);
        int oEnd = preImage.parseHunk(c, end);
        if (oEnd >= 0) {
            preImage.endOffset = c = oEnd;
            fh.reverseBinaryHunk = preImage;
        }
        return c;
    }

    void warn(byte[] buf, int ptr, String msg) {
        this.addError(new FormatError(buf, ptr, FormatError.Severity.WARNING, msg));
    }

    void error(byte[] buf, int ptr, String msg) {
        this.addError(new FormatError(buf, ptr, FormatError.Severity.ERROR, msg));
    }

    private static boolean matchAny(byte[] buf, int c, byte[][] srcs) {
        for (byte[] s : srcs) {
            if (RawParseUtils.match(buf, c, s) < 0) continue;
            return true;
        }
        return false;
    }
}

