/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revplot;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Commit;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.revplot.PlotCommit;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevSort;
import org.spearce.jgit.revwalk.RevWalk;

public class PlotWalk
extends RevWalk {
    private Map<AnyObjectId, Set<Ref>> reverseRefMap;

    public void dispose() {
        super.dispose();
        this.reverseRefMap.clear();
    }

    public PlotWalk(Repository repo) {
        super(repo);
        super.sort(RevSort.TOPO, true);
        this.reverseRefMap = repo.getAllRefsByPeeledObjectId();
    }

    public void sort(RevSort s, boolean use) {
        if (s == RevSort.TOPO && !use) {
            throw new IllegalArgumentException("Topological sort required.");
        }
        super.sort(s, use);
    }

    protected RevCommit createCommit(AnyObjectId id) {
        return new PlotCommit(id, this.getTags(id));
    }

    protected Ref[] getTags(AnyObjectId commitId) {
        Ref[] tags;
        Collection list = this.reverseRefMap.get(commitId);
        if (list == null) {
            tags = null;
        } else {
            tags = list.toArray(new Ref[list.size()]);
            Arrays.sort(tags, new PlotRefComparator());
        }
        return tags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlotRefComparator
    implements Comparator<Ref> {
        PlotRefComparator() {
        }

        @Override
        public int compare(Ref o1, Ref o2) {
            try {
                Object obj1 = PlotWalk.this.getRepository().mapObject(o1.getObjectId(), o1.getName());
                Object obj2 = PlotWalk.this.getRepository().mapObject(o2.getObjectId(), o2.getName());
                long t1 = this.timeof(obj1);
                long t2 = this.timeof(obj2);
                if (t1 > t2) {
                    return -1;
                }
                if (t1 < t2) {
                    return 1;
                }
                return 0;
            }
            catch (IOException e) {
                return 0;
            }
        }

        long timeof(Object o) {
            if (o instanceof Commit) {
                return ((Commit)o).getCommitter().getWhen().getTime();
            }
            if (o instanceof Tag) {
                return ((Tag)o).getTagger().getWhen().getTime();
            }
            return 0L;
        }
    }
}

