/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.AbstractRevQueue;
import org.spearce.jgit.revwalk.Generator;
import org.spearce.jgit.revwalk.RevCommit;

public class DateRevQueue
extends AbstractRevQueue {
    private Entry head;
    private Entry free;

    public DateRevQueue() {
    }

    DateRevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while ((c = s.next()) != null) {
            this.add(c);
        }
    }

    public void add(RevCommit c) {
        Entry q = this.head;
        long when = c.commitTime;
        Entry n = this.newEntry(c);
        if (q == null || when > (long)q.commit.commitTime) {
            n.next = q;
            this.head = n;
        } else {
            Entry p = q.next;
            while (p != null && (long)p.commit.commitTime > when) {
                q = p;
                p = q.next;
            }
            n.next = q.next;
            q.next = n;
        }
    }

    public RevCommit next() {
        Entry q = this.head;
        if (q == null) {
            return null;
        }
        this.head = q.next;
        this.freeEntry(q);
        return q.commit;
    }

    public RevCommit peek() {
        return this.head != null ? this.head.commit : null;
    }

    public void clear() {
        this.head = null;
        this.free = null;
    }

    boolean everbodyHasFlag(int f) {
        Entry q = this.head;
        while (q != null) {
            if ((q.commit.flags & f) == 0) {
                return false;
            }
            q = q.next;
        }
        return true;
    }

    boolean anybodyHasFlag(int f) {
        Entry q = this.head;
        while (q != null) {
            if ((q.commit.flags & f) != 0) {
                return true;
            }
            q = q.next;
        }
        return false;
    }

    int outputType() {
        return this.outputType | 1;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Entry q = this.head;
        while (q != null) {
            s.append(q.commit.name());
            s.append(' ');
            s.append(q.commit.commitTime);
            s.append('\n');
            q = q.next;
        }
        return s.toString();
    }

    private Entry newEntry(RevCommit c) {
        Entry r = this.free;
        if (r == null) {
            r = new Entry();
        } else {
            this.free = r.next;
        }
        r.commit = c;
        return r;
    }

    private void freeEntry(Entry e) {
        e.next = this.free;
        this.free = e;
    }

    static class Entry {
        Entry next;
        RevCommit commit;

        Entry() {
        }
    }
}

