/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.BlockRevQueue;
import org.spearce.jgit.revwalk.Generator;
import org.spearce.jgit.revwalk.RevCommit;

public class LIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue.Block head;

    public LIFORevQueue() {
    }

    LIFORevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s);
    }

    public void add(RevCommit c) {
        BlockRevQueue.Block b = this.head;
        if (b == null || !b.canUnpop()) {
            b = this.free.newBlock();
            b.resetToEnd();
            b.next = this.head;
            this.head = b;
        }
        b.unpop(c);
    }

    public RevCommit next() {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            return null;
        }
        RevCommit c = b.pop();
        if (b.isEmpty()) {
            this.head = b.next;
            this.free.freeBlock(b);
        }
        return c;
    }

    public void clear() {
        this.head = null;
        this.free.clear();
    }

    boolean everbodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            for (int i = b.headIndex; i < b.tailIndex; ++i) {
                if ((b.commits[i].flags & f) != 0) continue;
                return false;
            }
            b = b.next;
        }
        return true;
    }

    boolean anybodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            for (int i = b.headIndex; i < b.tailIndex; ++i) {
                if ((b.commits[i].flags & f) == 0) continue;
                return true;
            }
            b = b.next;
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        BlockRevQueue.Block q = this.head;
        while (q != null) {
            for (int i = q.headIndex; i < q.tailIndex; ++i) {
                s.append(q.commits[i].name());
                s.append(' ');
                s.append(q.commits[i].commitTime);
                s.append('\n');
            }
            q = q.next;
        }
        return s.toString();
    }
}

