/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.StopWalkException;
import org.spearce.jgit.revwalk.AbstractRevQueue;
import org.spearce.jgit.revwalk.DateRevQueue;
import org.spearce.jgit.revwalk.Generator;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    private final RevWalk walker;
    private final AbstractRevQueue pending;
    private final RevFilter filter;
    private final int output;
    boolean canDispose;

    PendingGenerator(RevWalk w, AbstractRevQueue p, RevFilter f, int out) {
        this.walker = w;
        this.pending = p;
        this.filter = f;
        this.output = out;
        this.canDispose = true;
    }

    int outputType() {
        if (this.pending instanceof DateRevQueue) {
            return this.output | 1;
        }
        return this.output;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                RevCommit c;
                if ((c = this.pending.next()) == null) {
                    this.walker.curs.release();
                    return null;
                }
                boolean produce = (c.flags & 4) != 0 ? false : this.filter.include(this.walker, c);
                for (RevCommit p : c.parents) {
                    if ((p.flags & 2) != 0) continue;
                    if ((p.flags & 1) == 0) {
                        p.parse(this.walker);
                    }
                    p.flags |= 2;
                    this.pending.add(p);
                }
                this.walker.carryFlagsImpl(c);
                if ((c.flags & 4) != 0) {
                    if (this.pending.everbodyHasFlag(4)) {
                        throw StopWalkException.INSTANCE;
                    }
                    c.dispose();
                    continue;
                }
                if (produce) {
                    return c;
                }
                if (!this.canDispose) continue;
                c.dispose();
            }
        }
        catch (StopWalkException swe) {
            this.walker.curs.release();
            this.pending.clear();
            return null;
        }
    }
}

