/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Commit;
import org.spearce.jgit.lib.MutableObjectId;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevTree;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.util.RawParseUtils;

public class RevCommit
extends RevObject {
    static final RevCommit[] NO_PARENTS = new RevCommit[0];
    private static final String TYPE_COMMIT = "commit";
    private RevTree tree;
    RevCommit[] parents;
    int commitTime;
    int inDegree;
    private byte[] buffer;

    protected RevCommit(AnyObjectId id) {
        super(id);
    }

    void parse(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = walk.db.openObject(walk.curs, this);
        if (ldr == null) {
            throw new MissingObjectException(this, TYPE_COMMIT);
        }
        byte[] data = ldr.getCachedBytes();
        if (1 != ldr.getType()) {
            throw new IncorrectObjectTypeException(this, TYPE_COMMIT);
        }
        this.parseCanonical(walk, data);
    }

    void parseCanonical(RevWalk walk, byte[] raw) {
        MutableObjectId idBuffer = walk.idBuffer;
        idBuffer.fromString(raw, 5);
        this.tree = walk.lookupTree(idBuffer);
        int ptr = 46;
        if (this.parents == null) {
            RevCommit[] pList = new RevCommit[1];
            int nParents = 0;
            while (raw[ptr] == 112) {
                idBuffer.fromString(raw, ptr + 7);
                RevCommit p = walk.lookupCommit(idBuffer);
                if (nParents == 0) {
                    pList[nParents++] = p;
                } else if (nParents == 1) {
                    pList = new RevCommit[]{pList[0], p};
                    nParents = 2;
                } else {
                    if (pList.length <= nParents) {
                        RevCommit[] old = pList;
                        pList = new RevCommit[pList.length + 32];
                        System.arraycopy(old, 0, pList, 0, nParents);
                    }
                    pList[nParents++] = p;
                }
                ptr += 48;
            }
            if (nParents != pList.length) {
                RevCommit[] old = pList;
                pList = new RevCommit[nParents];
                System.arraycopy(old, 0, pList, 0, nParents);
            }
            this.parents = pList;
        }
        if ((ptr = RawParseUtils.committer(raw, ptr)) > 0) {
            ptr = RawParseUtils.nextLF(raw, ptr, '>');
            this.commitTime = RawParseUtils.parseBase10(raw, ptr, null);
        }
        this.buffer = raw;
        this.flags |= 1;
    }

    public int getType() {
        return 1;
    }

    static void carryFlags(RevCommit c, int carry) {
        RevCommit[] pList;
        while ((pList = c.parents) != null) {
            int n = pList.length;
            if (n == 0) {
                return;
            }
            for (int i = 1; i < n; ++i) {
                RevCommit p = pList[i];
                if ((p.flags & carry) == carry) continue;
                p.flags |= carry;
                RevCommit.carryFlags(p, carry);
            }
            c = pList[0];
            if ((c.flags & carry) == carry) {
                return;
            }
            c.flags |= carry;
        }
        return;
    }

    public void carry(RevFlag flag) {
        int carry = this.flags & flag.mask;
        if (carry != 0) {
            RevCommit.carryFlags(this, carry);
        }
    }

    public final int getCommitTime() {
        return this.commitTime;
    }

    public final Commit asCommit(RevWalk walk) {
        return new Commit(walk.db, this, this.buffer);
    }

    public final RevTree getTree() {
        return this.tree;
    }

    public final int getParentCount() {
        return this.parents.length;
    }

    public final RevCommit getParent(int nth) {
        return this.parents[nth];
    }

    public final RevCommit[] getParents() {
        return this.parents;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final PersonIdent getAuthorIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.author(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final PersonIdent getCommitterIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.committer(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final String getFullMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        return RawParseUtils.decode(enc, raw, msgB, raw.length);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        String str = RawParseUtils.decode(enc, raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = str.replace('\n', ' ');
        }
        return str;
    }

    static boolean hasLF(byte[] r, int b, int e) {
        while (b < e) {
            if (r[b++] != 10) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.inDegree = 0;
    }

    public void dispose() {
        this.flags &= 0xFFFFFFFE;
        this.buffer = null;
    }
}

