/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevFlagSet;
import org.spearce.jgit.revwalk.RevWalk;

public abstract class RevObject
extends ObjectId {
    static final int PARSED = 1;
    int flags;

    RevObject(AnyObjectId name) {
        super(name);
    }

    abstract void parse(RevWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract int getType();

    public ObjectId getId() {
        return this;
    }

    public boolean equals(ObjectId o) {
        return this == o;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean has(RevFlag flag) {
        return (this.flags & flag.mask) != 0;
    }

    public boolean hasAny(RevFlagSet set) {
        return (this.flags & set.mask) != 0;
    }

    public boolean hasAll(RevFlagSet set) {
        return (this.flags & set.mask) == set.mask;
    }

    public void add(RevFlag flag) {
        this.flags |= flag.mask;
    }

    public void add(RevFlagSet set) {
        this.flags |= set.mask;
    }

    public void remove(RevFlag flag) {
        this.flags &= ~flag.mask;
    }

    public void remove(RevFlagSet set) {
        this.flags &= ~set.mask;
    }

    public void dispose() {
    }
}

