/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.util.MutableInteger;
import org.spearce.jgit.util.RawParseUtils;

public class RevTag
extends RevObject {
    private RevObject object;
    private byte[] buffer;
    private String name;

    protected RevTag(AnyObjectId id) {
        super(id);
    }

    void parse(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = walk.db.openObject(walk.curs, this);
        if (ldr == null) {
            throw new MissingObjectException(this, "tag");
        }
        byte[] data = ldr.getCachedBytes();
        if (4 != ldr.getType()) {
            throw new IncorrectObjectTypeException(this, "tag");
        }
        this.parseCanonical(walk, data);
    }

    void parseCanonical(RevWalk walk, byte[] rawTag) throws CorruptObjectException {
        MutableInteger pos = new MutableInteger();
        pos.value = 53;
        int oType = Constants.decodeTypeString(this, rawTag, (byte)10, pos);
        walk.idBuffer.fromString(rawTag, 7);
        this.object = walk.lookupAny(walk.idBuffer, oType);
        int p = pos.value += 4;
        int nameEnd = RawParseUtils.nextLF(rawTag, p) - 1;
        this.name = RawParseUtils.decode(Constants.CHARSET, rawTag, p, nameEnd);
        this.buffer = rawTag;
        this.flags |= 1;
    }

    public int getType() {
        return 4;
    }

    public final PersonIdent getTaggerIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.tagger(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final String getFullMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        return RawParseUtils.decode(enc, raw, msgB, raw.length);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        String str = RawParseUtils.decode(enc, raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = str.replace('\n', ' ');
        }
        return str;
    }

    public Tag asTag(RevWalk walk) {
        return new Tag(walk.db, this, this.name, this.buffer);
    }

    public RevObject getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.flags &= 0xFFFFFFFE;
        this.buffer = null;
    }
}

