/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.BlockRevQueue;
import org.spearce.jgit.revwalk.Generator;
import org.spearce.jgit.revwalk.RevCommit;

class RewriteGenerator
extends Generator {
    private static final int REWRITE = 8;
    private static final int DUPLICATE = 16;
    private final Generator source;

    RewriteGenerator(Generator s) {
        this.source = s;
    }

    void shareFreeList(BlockRevQueue q) {
        this.source.shareFreeList(q);
    }

    int outputType() {
        return this.source.outputType() & 0xFFFFFFFB;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c = this.source.next();
        if (c == null) {
            return null;
        }
        boolean rewrote = false;
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        for (int i = 0; i < nParents; ++i) {
            RevCommit oldp = pList[i];
            RevCommit newp = this.rewrite(oldp);
            if (oldp == newp) continue;
            pList[i] = newp;
            rewrote = true;
        }
        if (rewrote) {
            c.parents = this.cleanup(pList);
        }
        return c;
    }

    private RevCommit rewrite(RevCommit p) {
        RevCommit[] pList;
        while ((pList = p.parents).length <= 1) {
            if ((p.flags & 4) != 0) {
                return p;
            }
            if ((p.flags & 8) == 0) {
                return p;
            }
            if (pList.length == 0) {
                return null;
            }
            p = pList[0];
        }
        return p;
    }

    private RevCommit[] cleanup(RevCommit[] oldList) {
        int newCnt = 0;
        for (int o = 0; o < oldList.length; ++o) {
            RevCommit p = oldList[o];
            if (p == null) continue;
            if ((p.flags & 0x10) != 0) {
                oldList[o] = null;
                continue;
            }
            p.flags |= 0x10;
            ++newCnt;
        }
        if (newCnt == oldList.length) {
            for (RevCommit p : oldList) {
                p.flags &= 0xFFFFFFEF;
            }
            return oldList;
        }
        RevCommit[] newList = new RevCommit[newCnt];
        newCnt = 0;
        for (RevCommit p : oldList) {
            if (p == null) continue;
            newList[newCnt++] = p;
            p.flags &= 0xFFFFFFEF;
        }
        return newList;
    }
}

