/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.StopWalkException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;
import org.spearce.jgit.treewalk.TreeWalk;
import org.spearce.jgit.treewalk.filter.TreeFilter;

class RewriteTreeFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private static final int REWRITE = 8;
    private final TreeWalk pathFilter;

    RewriteTreeFilter(RevWalk walker, TreeFilter t) {
        this.pathFilter = new TreeWalk(walker.db);
        this.pathFilter.setFilter(t);
        this.pathFilter.setRecursive(t.shouldBeRecursive());
    }

    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        TreeWalk tw = this.pathFilter;
        AnyObjectId[] trees = new ObjectId[nParents + 1];
        for (int i = 0; i < nParents; ++i) {
            RevCommit p = c.parents[i];
            if ((p.flags & 1) == 0) {
                p.parse(walker);
            }
            trees[i] = p.getTree();
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        if (nParents == 1) {
            int chgs = 0;
            int adds = 0;
            while (tw.next()) {
                ++chgs;
                if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                ++adds;
            }
            if (chgs == 0) {
                c.flags |= 8;
                return false;
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= 8;
            return false;
        }
        int[] chgs = new int[nParents];
        int[] adds = new int[nParents];
        while (tw.next()) {
            int myMode = tw.getRawMode(nParents);
            for (int i = 0; i < nParents; ++i) {
                int pMode = tw.getRawMode(i);
                if (myMode == pMode && tw.idEqual(i, nParents)) continue;
                int n = i;
                chgs[n] = chgs[n] + 1;
                if (pMode != 0 || myMode == 0) continue;
                int n2 = i;
                adds[n2] = adds[n2] + 1;
            }
        }
        boolean same = false;
        boolean diff = false;
        for (int i = 0; i < nParents; ++i) {
            if (chgs[i] == 0) {
                RevCommit p = pList[i];
                if ((p.flags & 4) != 0) {
                    same = true;
                    continue;
                }
                c.flags |= 8;
                c.parents = new RevCommit[]{p};
                return false;
            }
            if (chgs[i] == adds[i]) {
                pList[i].parents = RevCommit.NO_PARENTS;
            }
            diff = true;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= 8;
        return false;
    }
}

