/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.AbstractRevQueue;
import org.spearce.jgit.revwalk.BoundaryGenerator;
import org.spearce.jgit.revwalk.DateRevQueue;
import org.spearce.jgit.revwalk.FIFORevQueue;
import org.spearce.jgit.revwalk.Generator;
import org.spearce.jgit.revwalk.LIFORevQueue;
import org.spearce.jgit.revwalk.MergeBaseGenerator;
import org.spearce.jgit.revwalk.ObjectWalk;
import org.spearce.jgit.revwalk.PendingGenerator;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevSort;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.RewriteGenerator;
import org.spearce.jgit.revwalk.RewriteTreeFilter;
import org.spearce.jgit.revwalk.TopoSortGenerator;
import org.spearce.jgit.revwalk.filter.AndRevFilter;
import org.spearce.jgit.revwalk.filter.RevFilter;
import org.spearce.jgit.treewalk.filter.TreeFilter;

class StartGenerator
extends Generator {
    private final RevWalk walker;

    StartGenerator(RevWalk w) {
        this.walker = w;
    }

    int outputType() {
        return 0;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk w = this.walker;
        RevFilter rf = w.getRevFilter();
        TreeFilter tf = w.getTreeFilter();
        AbstractRevQueue q = this.walker.queue;
        if (rf == RevFilter.MERGE_BASE) {
            if (tf != TreeFilter.ALL) {
                throw new IllegalStateException("Cannot combine TreeFilter " + tf + " with RevFilter " + rf + ".");
            }
            MergeBaseGenerator mbg = new MergeBaseGenerator(w);
            this.walker.pending = mbg;
            this.walker.queue = AbstractRevQueue.EMPTY_QUEUE;
            mbg.init(q);
            return mbg.next();
        }
        boolean boundary = this.walker.hasRevSort(RevSort.BOUNDARY);
        if (!boundary && this.walker instanceof ObjectWalk) {
            boundary = true;
        }
        if (boundary && !q.anybodyHasFlag(4)) {
            boundary = false;
        }
        int pendingOutputType = 0;
        if (this.walker.hasRevSort(RevSort.START_ORDER) && !(q instanceof FIFORevQueue)) {
            q = new FIFORevQueue(q);
        }
        if (this.walker.hasRevSort(RevSort.COMMIT_TIME_DESC) && !(q instanceof DateRevQueue)) {
            q = new DateRevQueue(q);
        }
        if (tf != TreeFilter.ALL) {
            rf = AndRevFilter.create(rf, new RewriteTreeFilter(w, tf));
            pendingOutputType |= 6;
        }
        this.walker.queue = q;
        Generator g = new PendingGenerator(w, q, rf, pendingOutputType);
        if (boundary) {
            ((PendingGenerator)g).canDispose = false;
        }
        if ((g.outputType() & 4) != 0) {
            g = new FIFORevQueue(g);
            g = new RewriteGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && (g.outputType() & 8) == 0) {
            g = new TopoSortGenerator(g);
        }
        if (this.walker.hasRevSort(RevSort.REVERSE)) {
            g = new LIFORevQueue(g);
        }
        if (boundary) {
            g = new BoundaryGenerator(w, g);
        }
        w.pending = g;
        return g.next();
    }
}

