/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Date;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.StopWalkException;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;

public abstract class CommitTimeRevFilter
extends RevFilter {
    final int when;

    public static final RevFilter before(Date ts) {
        return new Before(ts.getTime());
    }

    public static final RevFilter after(Date ts) {
        return new After(ts.getTime());
    }

    CommitTimeRevFilter(long ts) {
        this.when = (int)(ts / 1000L);
    }

    public RevFilter clone() {
        return this;
    }

    public String toString() {
        return super.toString() + "(" + new Date(this.when * 1000) + ")";
    }

    private static class After
    extends CommitTimeRevFilter {
        After(long ts) {
            super(ts);
        }

        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            if (cmit.getCommitTime() < this.when) {
                throw StopWalkException.INSTANCE;
            }
            return true;
        }
    }

    private static class Before
    extends CommitTimeRevFilter {
        Before(long ts) {
            super(ts);
        }

        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.when;
        }
    }
}

