/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk.filter;

import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.filter.PatternMatchRevFilter;
import org.spearce.jgit.revwalk.filter.RevFilter;
import org.spearce.jgit.revwalk.filter.SubStringRevFilter;
import org.spearce.jgit.util.RawCharSequence;
import org.spearce.jgit.util.RawParseUtils;

public class MessageRevFilter {
    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Cannot match on empty string.");
        }
        if (SubStringRevFilter.safe(pattern)) {
            return new SubStringSearch(pattern);
        }
        return new PatternSearch(pattern);
    }

    private MessageRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b = RawParseUtils.commitMessage(raw, 0);
        if (b < 0) {
            return RawCharSequence.EMPTY;
        }
        return new RawCharSequence(raw, b, raw.length);
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        protected RawCharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 34);
        }

        protected CharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }

        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }
}

