/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b;
        try {
            b = patternText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM lacks UTF-8 support.", e);
        }
        StringBuilder needle = new StringBuilder(b.length);
        for (int i = 0; i < b.length; ++i) {
            needle.append((char)(b[i] & 0xFF));
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Cannot match on empty string.");
        }
        this.patternText = pattern;
        if (innerString) {
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                pattern = ".*" + pattern;
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = pattern + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw(pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    protected abstract CharSequence text(RevCommit var1);

    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

