/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.revwalk.filter;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevFlagSet;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.revwalk.filter.RevFilter;

public abstract class RevFlagFilter
extends RevFilter {
    final RevFlagSet flags;

    public static RevFilter has(RevFlag a) {
        RevFlagSet s = new RevFlagSet();
        s.add(a);
        return new HasAll(s);
    }

    public static RevFilter hasAll(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        for (RevFlag flag : a) {
            set.add(flag);
        }
        return new HasAll(set);
    }

    public static RevFilter hasAll(RevFlagSet a) {
        return new HasAll(new RevFlagSet(a));
    }

    public static RevFilter hasAny(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        for (RevFlag flag : a) {
            set.add(flag);
        }
        return new HasAny(set);
    }

    public static RevFilter hasAny(RevFlagSet a) {
        return new HasAny(new RevFlagSet(a));
    }

    RevFlagFilter(RevFlagSet m) {
        this.flags = m;
    }

    public RevFilter clone() {
        return this;
    }

    public String toString() {
        return super.toString() + this.flags;
    }

    private static class HasAny
    extends RevFlagFilter {
        HasAny(RevFlagSet m) {
            super(m);
        }

        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAny(this.flags);
        }
    }

    private static class HasAll
    extends RevFlagFilter {
        HasAll(RevFlagSet m) {
            super(m);
        }

        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAll(this.flags);
        }
    }
}

