/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.spearce.jgit.awtui.AwtAuthenticator;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.NullProgressMonitor;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.transport.WalkEncryption;
import org.spearce.jgit.util.Base64;
import org.spearce.jgit.util.HttpSupport;
import org.spearce.jgit.util.TemporaryBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonS3 {
    private static final Set<String> SIGNED_HEADERS = new HashSet<String>();
    private static final String HMAC = "HmacSHA1";
    private static final String DOMAIN = "s3.amazonaws.com";
    private static final String X_AMZ_ACL = "x-amz-acl";
    private static final String X_AMZ_META = "x-amz-meta-";
    private final String publicKey;
    private final SecretKeySpec privateKey;
    private final ProxySelector proxySelector;
    private final String acl;
    private final int maxAttempts;
    private final WalkEncryption encryption;

    private static boolean isSignedHeader(String name) {
        String nameLC = name.toLowerCase();
        return SIGNED_HEADERS.contains(nameLC) || nameLC.startsWith("x-amz-");
    }

    private static String toCleanString(List<String> list) {
        StringBuilder s = new StringBuilder();
        for (String v : list) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append(v.replaceAll("\n", "").trim());
        }
        return s.toString();
    }

    private static String remove(Map<String, String> m, String k) {
        String r = m.remove(k);
        return r != null ? r : "";
    }

    private static String httpNow() {
        String tz = "GMT";
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date()) + " " + "GMT";
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JRE lacks MD5 implementation", e);
        }
    }

    public AmazonS3(Properties props) {
        this.publicKey = props.getProperty("accesskey");
        if (this.publicKey == null) {
            throw new IllegalArgumentException("Missing accesskey.");
        }
        String secret = props.getProperty("secretkey");
        if (secret == null) {
            throw new IllegalArgumentException("Missing secretkey.");
        }
        this.privateKey = new SecretKeySpec(Constants.encodeASCII(secret), HMAC);
        String pacl = props.getProperty("acl", "PRIVATE");
        if ("PRIVATE".equalsIgnoreCase(pacl)) {
            this.acl = "private";
        } else if ("PUBLIC".equalsIgnoreCase(pacl)) {
            this.acl = "public-read";
        } else if ("PUBLIC-READ".equalsIgnoreCase(pacl)) {
            this.acl = "public-read";
        } else if ("PUBLIC_READ".equalsIgnoreCase(pacl)) {
            this.acl = "public-read";
        } else {
            throw new IllegalArgumentException("Invalid acl: " + pacl);
        }
        try {
            String cPas = props.getProperty("password");
            if (cPas != null) {
                String cAlg = props.getProperty("crypto.algorithm");
                if (cAlg == null) {
                    cAlg = "PBEWithMD5AndDES";
                }
                this.encryption = new WalkEncryption.ObjectEncryptionV2(cAlg, cPas);
            } else {
                this.encryption = WalkEncryption.NONE;
            }
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid encryption", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid encryption", e);
        }
        this.maxAttempts = Integer.parseInt(props.getProperty("httpclient.retry-max", "3"));
        this.proxySelector = ProxySelector.getDefault();
    }

    public URLConnection get(String bucket, String key) throws IOException {
        block5: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("GET", bucket, key);
            this.authorize(c);
            switch (HttpSupport.response(c)) {
                case 200: {
                    this.encryption.validate(c, X_AMZ_META);
                    return c;
                }
                case 404: {
                    throw new FileNotFoundException(key);
                }
                case 500: {
                    continue block5;
                }
                default: {
                    throw this.error("Reading", key, c);
                }
            }
        }
        throw this.maxAttempts("Reading", key);
    }

    public InputStream decrypt(URLConnection u) throws IOException {
        return this.encryption.decrypt(u.getInputStream());
    }

    public List<String> list(String bucket, String prefix) throws IOException {
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        ListParser lp = new ListParser(bucket, prefix);
        do {
            lp.list();
        } while (lp.truncated);
        return lp.entries;
    }

    public void delete(String bucket, String key) throws IOException {
        block4: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("DELETE", bucket, key);
            this.authorize(c);
            switch (HttpSupport.response(c)) {
                case 204: {
                    return;
                }
                case 500: {
                    continue block4;
                }
                default: {
                    throw this.error("Deletion", key, c);
                }
            }
        }
        throw this.maxAttempts("Deletion", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String bucket, String key, byte[] data) throws IOException {
        if (this.encryption != WalkEncryption.NONE) {
            OutputStream os = this.beginPut(bucket, key, null, null);
            os.write(data);
            os.close();
            return;
        }
        String md5str = Base64.encodeBytes(AmazonS3.newMD5().digest(data));
        String lenstr = String.valueOf(data.length);
        block7: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("PUT", bucket, key);
            c.setRequestProperty("Content-Length", lenstr);
            c.setRequestProperty("Content-MD5", md5str);
            c.setRequestProperty(X_AMZ_ACL, this.acl);
            this.authorize(c);
            c.setDoOutput(true);
            c.setFixedLengthStreamingMode(data.length);
            OutputStream os = c.getOutputStream();
            try {
                os.write(data);
            }
            finally {
                os.close();
            }
            switch (HttpSupport.response(c)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block7;
                }
                default: {
                    throw this.error("Writing", key, c);
                }
            }
        }
        throw this.maxAttempts("Writing", key);
    }

    public OutputStream beginPut(final String bucket, final String key, final ProgressMonitor monitor, final String monitorTask) throws IOException {
        final MessageDigest md5 = AmazonS3.newMD5();
        TemporaryBuffer buffer = new TemporaryBuffer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                try {
                    AmazonS3.this.putImpl(bucket, key, md5.digest(), this, monitor, monitorTask);
                }
                finally {
                    this.destroy();
                }
            }
        };
        return this.encryption.encrypt(new DigestOutputStream(buffer, md5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putImpl(String bucket, String key, byte[] csum, TemporaryBuffer buf, ProgressMonitor monitor, String monitorTask) throws IOException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (monitorTask == null) {
            monitorTask = "Uploading " + key;
        }
        String md5str = Base64.encodeBytes(csum);
        long len = buf.length();
        String lenstr = String.valueOf(len);
        block7: for (int curAttempt = 0; curAttempt < this.maxAttempts; ++curAttempt) {
            HttpURLConnection c = this.open("PUT", bucket, key);
            c.setRequestProperty("Content-Length", lenstr);
            c.setRequestProperty("Content-MD5", md5str);
            c.setRequestProperty(X_AMZ_ACL, this.acl);
            this.encryption.request(c, X_AMZ_META);
            this.authorize(c);
            c.setDoOutput(true);
            c.setFixedLengthStreamingMode((int)len);
            monitor.beginTask(monitorTask, (int)(len / 1024L));
            OutputStream os = c.getOutputStream();
            try {
                buf.writeTo(os, monitor);
            }
            finally {
                monitor.endTask();
                os.close();
            }
            switch (HttpSupport.response(c)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block7;
                }
                default: {
                    throw this.error("Writing", key, c);
                }
            }
        }
        throw this.maxAttempts("Writing", key);
    }

    private IOException error(String action, String key, HttpURLConnection c) throws IOException {
        int n;
        IOException err = new IOException(action + " of '" + key + "' failed: " + HttpSupport.response(c) + " " + c.getResponseMessage());
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((n = c.getErrorStream().read(buf)) >= 0) {
            if (n <= 0) continue;
            b.write(buf, 0, n);
        }
        buf = b.toByteArray();
        if (buf.length > 0) {
            err.initCause(new IOException("\n" + new String(buf)));
        }
        return err;
    }

    private IOException maxAttempts(String action, String key) {
        return new IOException(action + " of '" + key + "' failed:" + " Giving up after " + this.maxAttempts + " attempts.");
    }

    private HttpURLConnection open(String method, String bucket, String key) throws IOException {
        Map<String, String> noArgs = Collections.emptyMap();
        return this.open(method, bucket, key, noArgs);
    }

    private HttpURLConnection open(String method, String bucket, String key, Map<String, String> args) throws IOException {
        StringBuilder urlstr = new StringBuilder();
        urlstr.append("http://");
        urlstr.append(bucket);
        urlstr.append('.');
        urlstr.append(DOMAIN);
        urlstr.append('/');
        if (key.length() > 0) {
            HttpSupport.encode(urlstr, key);
        }
        if (!args.isEmpty()) {
            urlstr.append('?');
            Iterator<Map.Entry<String, String>> i = args.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> e = i.next();
                urlstr.append(e.getKey());
                urlstr.append('=');
                HttpSupport.encode(urlstr, e.getValue());
                if (!i.hasNext()) continue;
                urlstr.append('&');
            }
        }
        URL url = new URL(urlstr.toString());
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, url);
        HttpURLConnection c = (HttpURLConnection)url.openConnection(proxy);
        c.setRequestMethod(method);
        c.setRequestProperty("User-Agent", "jgit/1.0");
        c.setRequestProperty("Date", AmazonS3.httpNow());
        return c;
    }

    private void authorize(HttpURLConnection c) throws IOException {
        String sec;
        Map<String, List<String>> reqHdr = c.getRequestProperties();
        TreeMap<String, String> sigHdr = new TreeMap<String, String>();
        for (String hdr : reqHdr.keySet()) {
            if (!AmazonS3.isSignedHeader(hdr)) continue;
            sigHdr.put(hdr.toLowerCase(), AmazonS3.toCleanString(reqHdr.get(hdr)));
        }
        StringBuilder s = new StringBuilder();
        s.append(c.getRequestMethod());
        s.append('\n');
        s.append(AmazonS3.remove(sigHdr, "content-md5"));
        s.append('\n');
        s.append(AmazonS3.remove(sigHdr, "content-type"));
        s.append('\n');
        s.append(AmazonS3.remove(sigHdr, "date"));
        s.append('\n');
        for (Map.Entry e : sigHdr.entrySet()) {
            s.append((String)e.getKey());
            s.append(':');
            s.append((String)e.getValue());
            s.append('\n');
        }
        String host = c.getURL().getHost();
        s.append('/');
        s.append(host.substring(0, host.length() - DOMAIN.length() - 1));
        s.append(c.getURL().getPath());
        try {
            Mac m = Mac.getInstance(HMAC);
            m.init(this.privateKey);
            sec = Base64.encodeBytes(m.doFinal(s.toString().getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("No HmacSHA1 support:" + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new IOException("Invalid key: " + e.getMessage());
        }
        c.setRequestProperty("Authorization", "AWS " + this.publicKey + ":" + sec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        if (argv.length != 4) {
            AmazonS3.commandLineUsage();
            return;
        }
        AwtAuthenticator.install();
        HttpSupport.configureHttpProxy();
        AmazonS3 s3 = new AmazonS3(AmazonS3.properties(new File(argv[0])));
        String op = argv[1];
        String bucket = argv[2];
        String key = argv[3];
        if ("get".equals(op)) {
            URLConnection c = s3.get(bucket, key);
            InputStream in = c.getInputStream();
            try {
                int n;
                byte[] tmp = new byte[2048];
                for (int len = c.getContentLength(); len > 0; len -= n) {
                    n = in.read(tmp);
                    if (n < 0) {
                        throw new EOFException("Expected " + len + " bytes.");
                    }
                    System.out.write(tmp, 0, n);
                }
            }
            finally {
                in.close();
            }
        } else if ("ls".equals(op) || "list".equals(op)) {
            for (String k : s3.list(bucket, key)) {
                System.out.println(k);
            }
        } else if ("rm".equals(op) || "delete".equals(op)) {
            s3.delete(bucket, key);
        } else if ("put".equals(op)) {
            int n;
            OutputStream os = s3.beginPut(bucket, key, null, null);
            byte[] tmp = new byte[2048];
            while ((n = System.in.read(tmp)) > 0) {
                os.write(tmp, 0, n);
            }
            os.close();
        } else {
            AmazonS3.commandLineUsage();
        }
    }

    private static void commandLineUsage() {
        System.err.println("usage: conn.prop op bucket key");
        System.err.println();
        System.err.println("    where conn.prop is a jets3t properties file.");
        System.err.println("    op is one of: get ls rm put");
        System.err.println("    bucket is the name of the S3 bucket");
        System.err.println("    key is the name of the object.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties properties(File authFile) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(authFile);
        try {
            p.load(in);
        }
        finally {
            in.close();
        }
        return p;
    }

    static {
        SIGNED_HEADERS.add("content-type");
        SIGNED_HEADERS.add("content-md5");
        SIGNED_HEADERS.add("date");
    }

    private final class ListParser
    extends DefaultHandler {
        final List<String> entries = new ArrayList<String>();
        private final String bucket;
        private final String prefix;
        boolean truncated;
        private StringBuilder data;

        ListParser(String bn, String p) {
            this.bucket = bn;
            this.prefix = p;
        }

        void list() throws IOException {
            TreeMap<String, String> args = new TreeMap<String, String>();
            if (this.prefix.length() > 0) {
                args.put("prefix", this.prefix);
            }
            if (!this.entries.isEmpty()) {
                args.put("marker", this.prefix + this.entries.get(this.entries.size() - 1));
            }
            block11: for (int curAttempt = 0; curAttempt < AmazonS3.this.maxAttempts; ++curAttempt) {
                HttpURLConnection c = AmazonS3.this.open("GET", this.bucket, "", args);
                AmazonS3.this.authorize(c);
                switch (HttpSupport.response(c)) {
                    case 200: {
                        XMLReader xr;
                        this.truncated = false;
                        this.data = null;
                        try {
                            xr = XMLReaderFactory.createXMLReader();
                        }
                        catch (SAXException e) {
                            throw new IOException("No XML parser available.");
                        }
                        xr.setContentHandler(this);
                        InputStream in = c.getInputStream();
                        try {
                            xr.parse(new InputSource(in));
                        }
                        catch (SAXException parsingError) {
                            IOException p = new IOException("Error listing " + this.prefix);
                            p.initCause(parsingError);
                            throw p;
                        }
                        finally {
                            in.close();
                        }
                        return;
                    }
                    case 500: {
                        continue block11;
                    }
                    default: {
                        throw AmazonS3.this.error("Listing", this.prefix, c);
                    }
                }
            }
            throw AmazonS3.this.maxAttempts("Listing", this.prefix);
        }

        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            if ("Key".equals(name) || "IsTruncated".equals(name)) {
                this.data = new StringBuilder();
            }
        }

        public void ignorableWhitespace(char[] ch, int s, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s, n);
            }
        }

        public void characters(char[] ch, int s, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s, n);
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if ("Key".equals(name)) {
                this.entries.add(this.data.toString().substring(this.prefix.length()));
            } else if ("IsTruncated".equals(name)) {
                this.truncated = "true".equalsIgnoreCase(this.data.toString());
            }
            this.data = null;
        }
    }
}

