/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.spearce.jgit.errors.NoRemoteRepositoryException;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.BaseConnection;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PacketLineIn;
import org.spearce.jgit.transport.PacketLineOut;
import org.spearce.jgit.transport.URIish;

abstract class BasePackConnection
extends BaseConnection {
    protected final Repository local;
    protected final URIish uri;
    protected final PackTransport transport;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    private final Set<String> remoteCapablities = new HashSet<String>();
    protected final Set<ObjectId> additionalHaves = new HashSet<ObjectId>();

    BasePackConnection(PackTransport packTransport) {
        this.local = packTransport.local;
        this.uri = packTransport.uri;
        this.transport = packTransport;
    }

    protected void init(InputStream myIn, OutputStream myOut) {
        this.in = myIn instanceof BufferedInputStream ? myIn : new BufferedInputStream(myIn, 8192);
        this.out = myOut instanceof BufferedOutputStream ? myOut : new BufferedOutputStream(myOut);
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected void readAdvertisedRefs() throws TransportException {
        try {
            this.readAdvertisedRefsImpl();
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private void readAdvertisedRefsImpl() throws IOException {
        LinkedHashMap<String, Ref> avail;
        block10: {
            String name;
            avail = new LinkedHashMap<String, Ref>();
            while (true) {
                int nul;
                String line;
                try {
                    line = this.pckIn.readString();
                }
                catch (EOFException eof) {
                    if (avail.isEmpty()) {
                        throw this.noRepository();
                    }
                    throw eof;
                }
                if (avail.isEmpty() && (nul = line.indexOf(0)) >= 0) {
                    for (String c : line.substring(nul + 1).split(" ")) {
                        this.remoteCapablities.add(c);
                    }
                    line = line.substring(0, nul);
                }
                if (line.length() == 0) break block10;
                name = line.substring(41, line.length());
                if (avail.isEmpty() && name.equals("capabilities^{}")) continue;
                ObjectId id = ObjectId.fromString(line.substring(0, 40));
                if (name.equals(".have")) {
                    this.additionalHaves.add(id);
                    continue;
                }
                if (name.endsWith("^{}")) {
                    Ref prior = avail.get(name = name.substring(0, name.length() - 3));
                    if (prior == null) {
                        throw new PackProtocolException(this.uri, "advertisement of " + name + "^{} came before " + name);
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(name + "^{}");
                    }
                    avail.put(name, new Ref(Ref.Storage.NETWORK, name, prior.getObjectId(), id, true));
                    continue;
                }
                Ref prior = avail.put(name, new Ref(Ref.Storage.NETWORK, name, id));
                if (prior != null) break;
            }
            throw this.duplicateAdvertisement(name);
        }
        this.available(avail);
    }

    protected TransportException noRepository() {
        return new NoRemoteRepositoryException(this.uri, "not found.");
    }

    protected boolean isCapableOf(String option) {
        return this.remoteCapablities.contains(option);
    }

    protected boolean wantCapability(StringBuilder b, String option) {
        if (!this.isCapableOf(option)) {
            return false;
        }
        b.append(' ');
        b.append(option);
        return true;
    }

    private PackProtocolException duplicateAdvertisement(String name) {
        return new PackProtocolException(this.uri, "duplicate advertisements of " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.out != null) {
            try {
                if (this.outNeedsEnd) {
                    this.pckOut.end();
                }
                this.out.close();
            }
            catch (IOException err) {
            }
            finally {
                this.out = null;
                this.pckOut = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
                this.pckIn = null;
            }
        }
    }
}

