/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.spearce.jgit.errors.NoRemoteRepositoryException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackWriter;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.transport.BasePackConnection;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.RemoteRefUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasePackPushConnection
extends BasePackConnection
implements PushConnection {
    static final String CAPABILITY_REPORT_STATUS = "report-status";
    static final String CAPABILITY_DELETE_REFS = "delete-refs";
    private final boolean thinPack;
    private boolean capableDeleteRefs;
    private boolean capableReport;
    private boolean sentCommand;
    private boolean writePack;

    BasePackPushConnection(PackTransport transport) {
        super(transport);
        this.thinPack = transport.isPushThin();
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        this.markStartedOperation();
        this.doPush(monitor, refUpdates);
    }

    @Override
    protected TransportException noRepository() {
        try {
            this.transport.openFetch().close();
        }
        catch (NotSupportedException e) {
        }
        catch (NoRemoteRepositoryException e) {
            return e;
        }
        catch (TransportException transportException) {
            // empty catch block
        }
        return new TransportException(this.uri, "push not permitted");
    }

    protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        try {
            this.writeCommands(refUpdates.values(), monitor);
            if (this.writePack) {
                this.writePack(refUpdates, monitor);
            }
            if (this.sentCommand && this.capableReport) {
                this.readStatusReport(refUpdates);
            }
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransportException(this.uri, e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private void writeCommands(Collection<RemoteRefUpdate> refUpdates, ProgressMonitor monitor) throws IOException {
        String capabilities = this.enableCapabilities();
        for (RemoteRefUpdate rru : refUpdates) {
            if (!this.capableDeleteRefs && rru.isDelete()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NODELETE);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            Ref advertisedRef = this.getRef(rru.getRemoteName());
            ObjectId oldId = advertisedRef == null ? ObjectId.zeroId() : advertisedRef.getObjectId();
            sb.append(oldId.name());
            sb.append(' ');
            sb.append(rru.getNewObjectId().name());
            sb.append(' ');
            sb.append(rru.getRemoteName());
            if (!this.sentCommand) {
                this.sentCommand = true;
                sb.append(capabilities);
            }
            this.pckOut.writeString(sb.toString());
            rru.setStatus(this.sentCommand ? RemoteRefUpdate.Status.AWAITING_REPORT : RemoteRefUpdate.Status.OK);
            if (rru.isDelete()) continue;
            this.writePack = true;
        }
        if (monitor.isCancelled()) {
            throw new TransportException(this.uri, "push cancelled");
        }
        this.pckOut.end();
        this.outNeedsEnd = false;
    }

    private String enableCapabilities() {
        StringBuilder line = new StringBuilder();
        this.capableReport = this.wantCapability(line, CAPABILITY_REPORT_STATUS);
        this.capableDeleteRefs = this.wantCapability(line, CAPABILITY_DELETE_REFS);
        if (line.length() > 0) {
            line.setCharAt(0, '\u0000');
        }
        return line.toString();
    }

    private void writePack(Map<String, RemoteRefUpdate> refUpdates, ProgressMonitor monitor) throws IOException {
        PackWriter writer = new PackWriter(this.local, monitor);
        ArrayList<ObjectId> remoteObjects = new ArrayList<ObjectId>(this.getRefs().size());
        ArrayList<ObjectId> newObjects = new ArrayList<ObjectId>(refUpdates.size());
        for (Ref ref : this.getRefs()) {
            remoteObjects.add(ref.getObjectId());
        }
        remoteObjects.addAll(this.additionalHaves);
        for (RemoteRefUpdate remoteRefUpdate : refUpdates.values()) {
            if (ObjectId.zeroId().equals(remoteRefUpdate.getNewObjectId())) continue;
            newObjects.add(remoteRefUpdate.getNewObjectId());
        }
        writer.preparePack(newObjects, remoteObjects, this.thinPack, true);
        writer.writePack(this.out);
    }

    private void readStatusReport(Map<String, RemoteRefUpdate> refUpdates) throws IOException {
        String refLine;
        String unpackLine = this.pckIn.readString();
        if (!unpackLine.startsWith("unpack ")) {
            throw new PackProtocolException(this.uri, "unexpected report line: " + unpackLine);
        }
        String unpackStatus = unpackLine.substring("unpack ".length());
        if (!unpackStatus.equals("ok")) {
            throw new TransportException(this.uri, "error occurred during unpacking on the remote end: " + unpackStatus);
        }
        while ((refLine = this.pckIn.readString()).length() > 0) {
            boolean ok = false;
            int refNameEnd = -1;
            if (refLine.startsWith("ok ")) {
                ok = true;
                refNameEnd = refLine.length();
            } else if (refLine.startsWith("ng ")) {
                ok = false;
                refNameEnd = refLine.indexOf(" ", 3);
            }
            if (refNameEnd == -1) {
                throw new PackProtocolException(this.uri + ": unexpected report line: " + refLine);
            }
            String refName = refLine.substring(3, refNameEnd);
            String message = ok ? null : refLine.substring(refNameEnd + 1);
            RemoteRefUpdate rru = refUpdates.get(refName);
            if (rru == null) {
                throw new PackProtocolException(this.uri + ": unexpected ref report: " + refName);
            }
            if (ok) {
                rru.setStatus(RemoteRefUpdate.Status.OK);
                continue;
            }
            rru.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            rru.setMessage(message);
        }
        for (RemoteRefUpdate rru : refUpdates.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.AWAITING_REPORT) continue;
            throw new PackProtocolException(this.uri + ": expected report for ref " + rru.getRemoteName() + " not received");
        }
    }
}

