/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.DaemonClient;
import org.spearce.jgit.transport.DaemonService;
import org.spearce.jgit.transport.ReceivePack;
import org.spearce.jgit.transport.UploadPack;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private boolean exportAll;
    private Map<String, Repository> exports;
    private Collection<File> exportBase;
    private boolean run;
    private Thread acceptThread;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress addr) {
        this.myAddress = addr;
        this.exports = new HashMap<String, Repository>();
        this.exportBase = new ArrayList<File>();
        this.processors = new ThreadGroup("Git-Daemon");
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException {
                UploadPack rp = new UploadPack(db);
                InputStream in = dc.getInputStream();
                rp.upload(in, dc.getOutputStream(), null);
            }
        }, new DaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(false);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException {
                InetAddress peer = dc.getRemoteAddress();
                String host = peer.getCanonicalHostName();
                if (host == null) {
                    host = peer.getHostAddress();
                }
                ReceivePack rp = new ReceivePack(db);
                InputStream in = dc.getInputStream();
                String name = "anonymous";
                String email = "anonymous@" + host;
                rp.setRefLogIdent(new PersonIdent("anonymous", email));
                rp.receive(in, dc.getOutputStream(), null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public synchronized boolean isExportAll() {
        return this.exportAll;
    }

    public synchronized void setExportAll(boolean export) {
        this.exportAll = export;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRepository(String name, Repository db) {
        Map<String, Repository> map = this.exports;
        synchronized (map) {
            this.exports.put(name, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDirectory(File dir) {
        Collection<File> collection = this.exportBase;
        synchronized (collection) {
            this.exportBase.add(dir);
        }
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException("Daemon already running");
        }
        final ServerSocket listenSock = new ServerSocket(this.myAddress != null ? this.myAddress.getPort() : 0, 5, this.myAddress != null ? this.myAddress.getAddress() : null);
        this.myAddress = (InetSocketAddress)listenSock.getLocalSocketAddress();
        this.run = true;
        this.acceptThread = new Thread(this.processors, "Git-Daemon-Accept"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (Daemon.this.isRunning()) {
                    try {
                        Daemon.this.startClient(listenSock.accept());
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    listenSock.close();
                }
                catch (IOException iOException) {
                    Daemon daemon = Daemon.this;
                    synchronized (daemon) {
                        Daemon.this.acceptThread = null;
                    }
                }
                finally {
                    Daemon e = Daemon.this;
                    synchronized (e) {
                        Daemon.this.acceptThread = null;
                    }
                }
            }
        };
        this.acceptThread.start();
    }

    public synchronized boolean isRunning() {
        return this.run;
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.run = false;
            this.acceptThread.interrupt();
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    dc.execute(new BufferedInputStream(s.getInputStream()), new BufferedOutputStream(s.getOutputStream()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository openRepository(String name) {
        File[] search;
        Repository db;
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        if (name.startsWith("//")) {
            return null;
        }
        if (name.contains("/../")) {
            return null;
        }
        name = name.substring(1);
        Map<String, Repository> map = this.exports;
        synchronized (map) {
            db = this.exports.get(name);
            if (db != null) {
                return db;
            }
            db = this.exports.get(name + ".git");
            if (db != null) {
                return db;
            }
        }
        Collection<File> collection = this.exportBase;
        synchronized (collection) {
            search = this.exportBase.toArray(new File[this.exportBase.size()]);
        }
        for (File f : search) {
            db = this.openRepository(new File(f, name));
            if (db != null) {
                return db;
            }
            db = this.openRepository(new File(f, name + ".git"));
            if (db != null) {
                return db;
            }
            db = this.openRepository(new File(f, name + "/.git"));
            if (db == null) continue;
            return db;
        }
        return null;
    }

    private Repository openRepository(File d) {
        if (d.isDirectory() && this.canExport(d)) {
            try {
                return new Repository(d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean canExport(File d) {
        if (this.isExportAll()) {
            return true;
        }
        return new File(d, "git-daemon-export-ok").exists();
    }
}

