/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.spearce.jgit.transport.Daemon;
import org.spearce.jgit.transport.DaemonService;
import org.spearce.jgit.transport.PacketLineIn;

public class DaemonClient {
    private final Daemon daemon;
    private InetAddress peer;
    private InputStream rawIn;
    private OutputStream rawOut;

    DaemonClient(Daemon d) {
        this.daemon = d;
    }

    void setRemoteAddress(InetAddress ia) {
        this.peer = ia;
    }

    public Daemon getDaemon() {
        return this.daemon;
    }

    public InetAddress getRemoteAddress() {
        return this.peer;
    }

    public InputStream getInputStream() {
        return this.rawIn;
    }

    public OutputStream getOutputStream() {
        return this.rawOut;
    }

    void execute(InputStream in, OutputStream out) throws IOException {
        DaemonService srv;
        this.rawIn = in;
        this.rawOut = out;
        String cmd = new PacketLineIn(this.rawIn).readStringNoLF();
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        int nul = cmd.indexOf(0);
        if (nul >= 0) {
            cmd = cmd.substring(0, nul);
        }
        if ((srv = this.getDaemon().matchService(cmd)) == null) {
            return;
        }
        srv.execute(this, cmd);
    }
}

