/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.DaemonClient;

public abstract class DaemonService {
    private final String command;
    private final String config;
    private boolean enabled;
    private boolean overridable;

    protected DaemonService(String cmdName, String cfgName) {
        this.command = cmdName.startsWith("git-") ? cmdName : "git-" + cmdName;
        this.config = cfgName;
        this.overridable = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean on) {
        this.overridable = on;
    }

    public String getCommandName() {
        return this.command;
    }

    public boolean handles(String commandLine) {
        return this.command.length() + 1 < commandLine.length() && commandLine.charAt(this.command.length()) == ' ' && commandLine.startsWith(this.command);
    }

    void execute(DaemonClient client, String commandLine) throws IOException {
        String name = commandLine.substring(this.command.length() + 1);
        Repository db = client.getDaemon().openRepository(name);
        if (db == null) {
            return;
        }
        boolean on = this.isEnabled();
        if (this.isOverridable()) {
            on = db.getConfig().getBoolean("daemon", this.config, on);
        }
        if (on) {
            this.execute(client, db);
        }
    }

    protected abstract void execute(DaemonClient var1, Repository var2) throws IOException;
}

