/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.spearce.jgit.transport.OpenSshConfig;
import org.spearce.jgit.transport.SshSessionFactory;
import org.spearce.jgit.util.FS;

class DefaultSshSessionFactory
extends SshSessionFactory {
    static final int SSH_PORT = 22;
    private Set<String> loadedIdentities;
    private JSch userJSch;
    private OpenSshConfig config;

    DefaultSshSessionFactory() {
    }

    public synchronized Session getSession(String user, String pass, String host, int port) throws JSchException {
        OpenSshConfig.Host hc = this.getConfig().lookup(host);
        host = hc.getHostName();
        if (port <= 0) {
            port = hc.getPort();
        }
        if (user == null) {
            user = hc.getUser();
        }
        Session session = this.getUserJSch().getSession(user, host, port);
        if (hc.getIdentityFile() != null) {
            this.addIdentity(hc.getIdentityFile());
        }
        if (pass != null) {
            session.setPassword(pass);
        } else if (!hc.isBatchMode()) {
            session.setUserInfo((UserInfo)new AWT_UserInfo());
        }
        String pauth = hc.getPreferredAuthentications();
        if (pauth != null) {
            session.setConfig("PreferredAuthentications", pauth);
        }
        return session;
    }

    static String userName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.name");
            }
        });
    }

    private JSch getUserJSch() throws JSchException {
        if (this.userJSch == null) {
            this.loadedIdentities = new HashSet<String>();
            this.userJSch = new JSch();
            this.knownHosts(this.userJSch);
            this.identities();
        }
        return this.userJSch;
    }

    private OpenSshConfig getConfig() {
        if (this.config == null) {
            this.config = OpenSshConfig.get();
        }
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void knownHosts(JSch sch) throws JSchException {
        File home = FS.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try {
            FileInputStream in = new FileInputStream(known_hosts);
            try {
                sch.setKnownHosts((InputStream)in);
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException none) {
        }
        catch (IOException err) {
            // empty catch block
        }
    }

    private void identities() {
        File home = FS.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        File[] keys = sshdir.listFiles();
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            File k;
            File pk = keys[i];
            String n = pk.getName();
            if (!n.endsWith(".pub") || !(k = new File(sshdir, n.substring(0, n.length() - 4))).isFile()) continue;
            try {
                this.addIdentity(k);
                continue;
            }
            catch (JSchException e) {
                // empty catch block
            }
        }
    }

    private void addIdentity(File identityFile) throws JSchException {
        String path = identityFile.getAbsolutePath();
        if (!this.loadedIdentities.contains(path)) {
            this.userJSch.addIdentity(path);
            this.loadedIdentities.add(path);
        }
    }

    public OutputStream getErrorStream() {
        return new OutputStream(){
            private StringBuilder all = new StringBuilder();
            private StringBuilder sb = new StringBuilder();

            public String toString() {
                String r = this.all.toString();
                while (r.endsWith("\n")) {
                    r = r.substring(0, r.length() - 1);
                }
                return r;
            }

            public void write(int b) throws IOException {
                if (b == 13) {
                    System.err.print('\r');
                    return;
                }
                this.sb.append((char)b);
                if (b == 10) {
                    String line = this.sb.toString();
                    System.err.print(line);
                    this.all.append(line);
                    this.sb = new StringBuilder();
                }
            }
        };
    }

    private static class AWT_UserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String passwd;
        private String passphrase;

        private AWT_UserInfo() {
        }

        public void showMessage(String msg) {
            JOptionPane.showMessageDialog(null, msg);
        }

        public boolean promptYesNo(String msg) {
            return JOptionPane.showConfirmDialog(null, msg, "Warning", 0) == 0;
        }

        public boolean promptPassword(String msg) {
            this.passwd = null;
            JPasswordField passwordField = new JPasswordField(20);
            int result = JOptionPane.showConfirmDialog(null, new Object[]{passwordField}, msg, 2);
            if (result == 0) {
                this.passwd = new String(passwordField.getPassword());
                return true;
            }
            return false;
        }

        public boolean promptPassphrase(String msg) {
            this.passphrase = null;
            JPasswordField passwordField = new JPasswordField(20);
            int result = JOptionPane.showConfirmDialog(null, new Object[]{passwordField}, msg, 2);
            if (result == 0) {
                this.passphrase = new String(passwordField.getPassword());
                return true;
            }
            return false;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            gbc.gridx = 0;
            panel.add((Component)new JLabel(instruction), gbc);
            ++gbc.gridy;
            gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                gbc.fill = 0;
                gbc.gridx = 0;
                gbc.weightx = 1.0;
                panel.add((Component)new JLabel(prompt[i]), gbc);
                gbc.gridx = 1;
                gbc.fill = 2;
                gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                panel.add((Component)texts[i], gbc);
                ++gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, panel, destination + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                }
                return response;
            }
            return null;
        }
    }
}

