/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.LockFile;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.revwalk.ObjectWalk;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.FetchConnection;
import org.spearce.jgit.transport.FetchHeadRecord;
import org.spearce.jgit.transport.FetchResult;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.TagOpt;
import org.spearce.jgit.transport.TrackingRefUpdate;
import org.spearce.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchProcess {
    private final Transport transport;
    private final Collection<RefSpec> toFetch;
    private final TagOpt tagopt;
    private final HashMap<ObjectId, Ref> askFor = new HashMap();
    private final HashSet<ObjectId> have = new HashSet();
    private final ArrayList<TrackingRefUpdate> localUpdates = new ArrayList();
    private final ArrayList<FetchHeadRecord> fetchHeadUpdates = new ArrayList();
    private FetchConnection conn;

    FetchProcess(Transport t, Collection<RefSpec> f, TagOpt o) {
        this.transport = t;
        this.toFetch = f;
        this.tagopt = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ProgressMonitor monitor, FetchResult result) throws NotSupportedException, TransportException {
        this.askFor.clear();
        this.localUpdates.clear();
        this.fetchHeadUpdates.clear();
        this.conn = this.transport.openFetch();
        try {
            boolean includedTags;
            result.setAdvertisedRefs(this.transport.getURI(), this.conn.getRefsMap());
            HashSet<Ref> matched = new HashSet<Ref>();
            for (RefSpec spec : this.toFetch) {
                if (spec.getSource() == null) {
                    throw new TransportException("Source ref not specified for refspec: " + spec);
                }
                if (spec.isWildcard()) {
                    this.expandWildcard(spec, matched);
                    continue;
                }
                this.expandSingle(spec, matched);
            }
            Collection<Object> additionalTags = Collections.emptyList();
            if (this.tagopt == TagOpt.AUTO_FOLLOW) {
                additionalTags = this.expandAutoFollowTags();
            } else if (this.tagopt == TagOpt.FETCH_TAGS) {
                this.expandFetchTags();
            }
            if (!this.askFor.isEmpty() && !this.askForIsComplete()) {
                this.fetchObjects(monitor);
                includedTags = this.conn.didFetchIncludeTags();
                this.closeConnection();
            } else {
                includedTags = false;
            }
            if (this.tagopt == TagOpt.AUTO_FOLLOW && !additionalTags.isEmpty()) {
                this.have.addAll(this.askFor.keySet());
                this.askFor.clear();
                for (Ref ref : additionalTags) {
                    ObjectId id = ref.getPeeledObjectId();
                    if (id != null && !this.transport.local.hasObject(id)) continue;
                    this.wantTag(ref);
                }
                if (!(this.askFor.isEmpty() || includedTags && this.askForIsComplete())) {
                    this.reopenConnection();
                    if (!this.askFor.isEmpty()) {
                        this.fetchObjects(monitor);
                    }
                }
            }
        }
        finally {
            this.closeConnection();
        }
        RevWalk walk = new RevWalk(this.transport.local);
        for (TrackingRefUpdate u : this.localUpdates) {
            try {
                u.update(walk);
                result.add(u);
            }
            catch (IOException err) {
                throw new TransportException("Failure updating tracking ref " + u.getLocalName() + ": " + err.getMessage(), err);
            }
        }
        if (!this.fetchHeadUpdates.isEmpty()) {
            try {
                this.updateFETCH_HEAD(result);
            }
            catch (IOException err) {
                throw new TransportException("Failure updating FETCH_HEAD: " + err.getMessage(), err);
            }
        }
    }

    private void fetchObjects(ProgressMonitor monitor) throws TransportException {
        this.conn.fetch(monitor, this.askFor.values(), this.have);
        if (this.transport.isCheckFetchedObjects() && !this.conn.didFetchTestConnectivity() && !this.askForIsComplete()) {
            throw new TransportException(this.transport.getURI(), "peer did not supply a complete object graph");
        }
    }

    private void closeConnection() {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    private void reopenConnection() throws NotSupportedException, TransportException {
        if (this.conn != null) {
            return;
        }
        this.conn = this.transport.openFetch();
        HashMap<ObjectId, Ref> avail = new HashMap<ObjectId, Ref>();
        for (Ref r : this.conn.getRefs()) {
            avail.put(r.getObjectId(), r);
        }
        ArrayList<Ref> wants = new ArrayList<Ref>(this.askFor.values());
        this.askFor.clear();
        for (Ref want : wants) {
            Ref newRef = (Ref)avail.get(want.getObjectId());
            if (newRef != null) {
                this.askFor.put(newRef.getObjectId(), newRef);
                continue;
            }
            this.removeFetchHeadRecord(want.getObjectId());
            this.removeTrackingRefUpdate(want.getObjectId());
        }
    }

    private void removeTrackingRefUpdate(ObjectId want) {
        Iterator<TrackingRefUpdate> i = this.localUpdates.iterator();
        while (i.hasNext()) {
            TrackingRefUpdate u = i.next();
            if (!u.getNewObjectId().equals(want)) continue;
            i.remove();
        }
    }

    private void removeFetchHeadRecord(ObjectId want) {
        Iterator<FetchHeadRecord> i = this.fetchHeadUpdates.iterator();
        while (i.hasNext()) {
            FetchHeadRecord fh = i.next();
            if (!fh.newValue.equals(want)) continue;
            i.remove();
        }
    }

    private void updateFETCH_HEAD(FetchResult result) throws IOException {
        LockFile lock = new LockFile(new File(this.transport.local.getDirectory(), "FETCH_HEAD"));
        if (lock.lock()) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(lock.getOutputStream())){

                public void println() {
                    this.print('\n');
                }
            };
            for (FetchHeadRecord h : this.fetchHeadUpdates) {
                h.write(pw);
                result.add(h);
            }
            pw.close();
            lock.commit();
        }
    }

    private boolean askForIsComplete() throws TransportException {
        try {
            ObjectWalk ow = new ObjectWalk(this.transport.local);
            for (ObjectId want : this.askFor.keySet()) {
                ow.markStart(ow.parseAny(want));
            }
            for (Ref ref : this.transport.local.getAllRefs().values()) {
                ow.markUninteresting(ow.parseAny(ref.getObjectId()));
            }
            ow.checkConnectivity();
            return true;
        }
        catch (MissingObjectException e) {
            return false;
        }
        catch (IOException e) {
            throw new TransportException("Unable to check connectivity.", e);
        }
    }

    private void expandWildcard(RefSpec spec, Set<Ref> matched) throws TransportException {
        for (Ref src : this.conn.getRefs()) {
            if (!spec.matchSource(src) || !matched.add(src)) continue;
            this.want(src, spec.expandFromSource(src));
        }
    }

    private void expandSingle(RefSpec spec, Set<Ref> matched) throws TransportException {
        Ref src = this.conn.getRef(spec.getSource());
        if (src == null) {
            throw new TransportException("Remote does not have " + spec.getSource() + " available for fetch.");
        }
        if (matched.add(src)) {
            this.want(src, spec);
        }
    }

    private Collection<Ref> expandAutoFollowTags() throws TransportException {
        ArrayList<Ref> additionalTags = new ArrayList<Ref>();
        Map<String, Ref> have = this.transport.local.getAllRefs();
        for (Ref r : this.conn.getRefs()) {
            if (!FetchProcess.isTag(r)) continue;
            if (r.getPeeledObjectId() == null) {
                additionalTags.add(r);
                continue;
            }
            Ref local = have.get(r.getName());
            if (local != null) {
                if (r.getObjectId().equals(local.getObjectId())) continue;
                this.wantTag(r);
                continue;
            }
            if (this.askFor.containsKey(r.getPeeledObjectId()) || this.transport.local.hasObject(r.getPeeledObjectId())) {
                this.wantTag(r);
                continue;
            }
            additionalTags.add(r);
        }
        return additionalTags;
    }

    private void expandFetchTags() throws TransportException {
        Map<String, Ref> have = this.transport.local.getAllRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            if (!FetchProcess.isTag(r) || (local = have.get(r.getName())) != null && r.getObjectId().equals(local.getObjectId())) continue;
            this.wantTag(r);
        }
    }

    private void wantTag(Ref r) throws TransportException {
        this.want(r, new RefSpec().setSource(r.getName()).setDestination(r.getName()));
    }

    private void want(Ref src, RefSpec spec) throws TransportException {
        ObjectId newId = src.getObjectId();
        if (spec.getDestination() != null) {
            try {
                TrackingRefUpdate tru = this.createUpdate(spec, newId);
                if (newId.equals(tru.getOldObjectId())) {
                    return;
                }
                this.localUpdates.add(tru);
            }
            catch (IOException err) {
                throw new TransportException("Cannot resolve local tracking ref " + spec.getDestination() + " for updating.", err);
            }
        }
        this.askFor.put(newId, src);
        FetchHeadRecord fhr = new FetchHeadRecord();
        fhr.newValue = newId;
        fhr.notForMerge = spec.getDestination() != null;
        fhr.sourceName = src.getName();
        fhr.sourceURI = this.transport.getURI();
        this.fetchHeadUpdates.add(fhr);
    }

    private TrackingRefUpdate createUpdate(RefSpec spec, ObjectId newId) throws IOException {
        return new TrackingRefUpdate(this.transport.local, spec, newId, "fetch");
    }

    private static boolean isTag(Ref r) {
        return FetchProcess.isTag(r.getName());
    }

    private static boolean isTag(String name) {
        return name.startsWith("refs/tags/");
    }
}

