/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.BinaryDelta;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.InflaterCache;
import org.spearce.jgit.lib.MutableObjectId;
import org.spearce.jgit.lib.ObjectChecker;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectIdMap;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PackIndexWriter;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.transport.PackedObjectInfo;
import org.spearce.jgit.util.NB;

public class IndexPack {
    public static final String PROGRESS_DOWNLOAD = "Receiving objects";
    public static final String PROGRESS_RESOLVE_DELTA = "Resolving deltas";
    public static final int BUFFER_SIZE = 8192;
    private final Repository repo;
    private Inflater inflater;
    private final MessageDigest objectDigest;
    private final MutableObjectId tempObjectId;
    private InputStream in;
    private byte[] buf;
    private long bBase;
    private int bOffset;
    private int bAvail;
    private ObjectChecker objCheck;
    private boolean fixThin;
    private boolean keepEmpty;
    private int outputVersion;
    private final File dstPack;
    private final File dstIdx;
    private long objectCount;
    private PackedObjectInfo[] entries;
    private int deltaCount;
    private int entryCount;
    private final CRC32 crc = new CRC32();
    private ObjectIdMap<ArrayList<UnresolvedDelta>> baseById;
    private HashMap<Long, ArrayList<UnresolvedDelta>> baseByPos;
    private byte[] objectData;
    private MessageDigest packDigest;
    private RandomAccessFile packOut;
    private byte[] packcsum;
    private long originalEOF;
    private WindowCursor readCurs;

    public static IndexPack create(Repository db, InputStream is) throws IOException {
        String suffix = ".pack";
        File objdir = db.getObjectsDirectory();
        File tmp = File.createTempFile("incoming_", ".pack", objdir);
        String n = tmp.getName();
        File base = new File(objdir, n.substring(0, n.length() - ".pack".length()));
        IndexPack ip = new IndexPack(db, is, base);
        ip.setIndexVersion(db.getConfig().getCore().getPackIndexVersion());
        return ip;
    }

    public IndexPack(Repository db, InputStream src, File dstBase) throws IOException {
        this.repo = db;
        this.in = src;
        this.inflater = InflaterCache.get();
        this.readCurs = new WindowCursor();
        this.buf = new byte[8192];
        this.objectData = new byte[8192];
        this.objectDigest = Constants.newMessageDigest();
        this.tempObjectId = new MutableObjectId();
        this.packDigest = Constants.newMessageDigest();
        if (dstBase != null) {
            File dir = dstBase.getParentFile();
            String nam = dstBase.getName();
            this.dstPack = new File(dir, nam + ".pack");
            this.dstIdx = new File(dir, nam + ".idx");
            this.packOut = new RandomAccessFile(this.dstPack, "rw");
            this.packOut.setLength(0L);
        } else {
            this.dstPack = null;
            this.dstIdx = null;
        }
    }

    public void setIndexVersion(int version) {
        this.outputVersion = version;
    }

    public void setFixThin(boolean fix) {
        this.fixThin = fix;
    }

    public void setKeepEmpty(boolean empty) {
        this.keepEmpty = empty;
    }

    public void setObjectChecker(ObjectChecker oc) {
        this.objCheck = oc;
    }

    public void setObjectChecking(boolean on) {
        this.setObjectChecker(on ? new ObjectChecker() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(ProgressMonitor progress) throws IOException {
        progress.start(2);
        try {
            try {
                this.readPackHeader();
                this.entries = new PackedObjectInfo[(int)this.objectCount];
                this.baseById = new ObjectIdMap();
                this.baseByPos = new HashMap();
                progress.beginTask(PROGRESS_DOWNLOAD, (int)this.objectCount);
                int done = 0;
                while ((long)done < this.objectCount) {
                    this.indexOneObject();
                    progress.update(1);
                    if (progress.isCancelled()) {
                        throw new IOException("Download cancelled");
                    }
                    ++done;
                }
                this.readPackFooter();
                this.endInput();
                progress.endTask();
                if (this.deltaCount > 0) {
                    if (this.packOut == null) {
                        throw new IOException("need packOut");
                    }
                    this.resolveDeltas(progress);
                    if ((long)this.entryCount < this.objectCount) {
                        if (!this.fixThin) {
                            throw new IOException("pack has " + (this.objectCount - (long)this.entryCount) + " unresolved deltas");
                        }
                        this.fixThinPack(progress);
                    }
                }
                if (this.packOut != null && (this.keepEmpty || this.entryCount > 0)) {
                    this.packOut.getChannel().force(true);
                }
                this.packDigest = null;
                this.baseById = null;
                this.baseByPos = null;
                if (this.dstIdx != null && (this.keepEmpty || this.entryCount > 0)) {
                    this.writeIdx();
                }
            }
            finally {
                try {
                    InflaterCache.release(this.inflater);
                }
                finally {
                    this.inflater = null;
                }
                this.readCurs = WindowCursor.release(this.readCurs);
                progress.endTask();
                if (this.packOut != null) {
                    this.packOut.close();
                }
            }
            if (this.keepEmpty || this.entryCount > 0) {
                if (this.dstPack != null) {
                    this.dstPack.setReadOnly();
                }
                if (this.dstIdx != null) {
                    this.dstIdx.setReadOnly();
                }
            }
        }
        catch (IOException err) {
            if (this.dstPack != null) {
                this.dstPack.delete();
            }
            if (this.dstIdx != null) {
                this.dstIdx.delete();
            }
            throw err;
        }
    }

    private void resolveDeltas(ProgressMonitor progress) throws IOException {
        progress.beginTask(PROGRESS_RESOLVE_DELTA, this.deltaCount);
        int last = this.entryCount;
        for (int i = 0; i < last; ++i) {
            int before = this.entryCount;
            this.resolveDeltas(this.entries[i]);
            progress.update(this.entryCount - before);
            if (!progress.isCancelled()) continue;
            throw new IOException("Download cancelled during indexing");
        }
        progress.endTask();
    }

    private void resolveDeltas(PackedObjectInfo oe) throws IOException {
        int oldCRC = oe.getCRC();
        if (this.baseById.containsKey(oe) || this.baseByPos.containsKey(new Long(oe.getOffset()))) {
            this.resolveDeltas(oe.getOffset(), oldCRC, -1, null, oe);
        }
    }

    private void resolveDeltas(long pos, int oldCRC, int type, byte[] data, PackedObjectInfo oe) throws IOException {
        this.crc.reset();
        this.position(pos);
        int c = this.readFromFile();
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFromFile();
            sz += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                type = typeCode;
                data = this.inflateFromFile((int)sz);
                break;
            }
            case 6: {
                c = this.readFromFile() & 0xFF;
                while ((c & 0x80) != 0) {
                    c = this.readFromFile() & 0xFF;
                }
                data = BinaryDelta.apply(data, this.inflateFromFile((int)sz));
                break;
            }
            case 7: {
                this.crc.update(this.buf, this.fillFromFile(20), 20);
                this.use(20);
                data = BinaryDelta.apply(data, this.inflateFromFile((int)sz));
                break;
            }
            default: {
                throw new IOException("Unknown object type " + typeCode + ".");
            }
        }
        int crc32 = (int)this.crc.getValue();
        if (oldCRC != crc32) {
            throw new IOException("Corruption detected re-reading at " + pos);
        }
        if (oe == null) {
            this.objectDigest.update(Constants.encodedTypeString(type));
            this.objectDigest.update((byte)32);
            this.objectDigest.update(Constants.encodeASCII(data.length));
            this.objectDigest.update((byte)0);
            this.objectDigest.update(data);
            this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
            this.verifySafeObject(this.tempObjectId, type, data);
            oe = new PackedObjectInfo(pos, crc32, this.tempObjectId);
            this.entries[this.entryCount++] = oe;
        }
        this.resolveChildDeltas(pos, type, data, oe);
    }

    private void resolveChildDeltas(long pos, int type, byte[] data, PackedObjectInfo oe) throws IOException {
        UnresolvedDelta ad;
        ArrayList<UnresolvedDelta> a = this.baseById.remove(oe);
        ArrayList<UnresolvedDelta> b = this.baseByPos.remove(new Long(pos));
        int ai = 0;
        int bi = 0;
        if (a != null && b != null) {
            while (ai < a.size() && bi < b.size()) {
                ad = a.get(ai);
                UnresolvedDelta bd = b.get(bi);
                if (ad.position < bd.position) {
                    this.resolveDeltas(ad.position, ad.crc, type, data, null);
                    ++ai;
                    continue;
                }
                this.resolveDeltas(bd.position, bd.crc, type, data, null);
                ++bi;
            }
        }
        if (a != null) {
            while (ai < a.size()) {
                ad = a.get(ai++);
                this.resolveDeltas(ad.position, ad.crc, type, data, null);
            }
        }
        if (b != null) {
            while (bi < b.size()) {
                UnresolvedDelta bd = b.get(bi++);
                this.resolveDeltas(bd.position, bd.crc, type, data, null);
            }
        }
    }

    private void fixThinPack(ProgressMonitor progress) throws IOException {
        this.growEntries();
        this.packDigest.reset();
        this.originalEOF = this.packOut.length() - 20L;
        Deflater def = new Deflater(-1, false);
        long end = this.originalEOF;
        for (ObjectId baseId : new ArrayList(this.baseById.keySet())) {
            ObjectLoader ldr = this.repo.openObject(this.readCurs, baseId);
            if (ldr == null) continue;
            byte[] data = ldr.getBytes();
            int typeCode = ldr.getType();
            this.crc.reset();
            this.packOut.seek(end);
            this.writeWhole(def, typeCode, data);
            PackedObjectInfo oe = new PackedObjectInfo(end, (int)this.crc.getValue(), baseId);
            this.entries[this.entryCount++] = oe;
            end = this.packOut.getFilePointer();
            this.resolveChildDeltas(oe.getOffset(), typeCode, data, oe);
            if (!progress.isCancelled()) continue;
            throw new IOException("Download cancelled during indexing");
        }
        def.end();
        if (!this.baseById.isEmpty()) {
            ObjectId need = (ObjectId)this.baseById.keySet().iterator().next();
            throw new MissingObjectException(need, "delta base");
        }
        this.fixHeaderFooter(this.packcsum, this.packDigest.digest());
    }

    private void writeWhole(Deflater def, int typeCode, byte[] data) throws IOException {
        int sz = data.length;
        int hdrlen = 0;
        this.buf[hdrlen++] = (byte)(typeCode << 4 | sz & 0xF);
        sz >>>= 4;
        while (sz > 0) {
            int n = hdrlen - 1;
            this.buf[n] = (byte)(this.buf[n] | 0x80);
            this.buf[hdrlen++] = (byte)(sz & 0x7F);
            sz >>>= 7;
        }
        this.packDigest.update(this.buf, 0, hdrlen);
        this.crc.update(this.buf, 0, hdrlen);
        this.packOut.write(this.buf, 0, hdrlen);
        def.reset();
        def.setInput(data);
        def.finish();
        while (!def.finished()) {
            int datlen = def.deflate(this.buf);
            this.packDigest.update(this.buf, 0, datlen);
            this.crc.update(this.buf, 0, datlen);
            this.packOut.write(this.buf, 0, datlen);
        }
    }

    private void fixHeaderFooter(byte[] origcsum, byte[] tailcsum) throws IOException {
        int n;
        MessageDigest origDigest = Constants.newMessageDigest();
        MessageDigest tailDigest = Constants.newMessageDigest();
        long origRemaining = this.originalEOF;
        this.packOut.seek(0L);
        this.bAvail = 0;
        this.bOffset = 0;
        this.fillFromFile(12);
        int origCnt = (int)Math.min((long)this.bAvail, origRemaining);
        origDigest.update(this.buf, 0, origCnt);
        if ((origRemaining -= (long)origCnt) == 0L) {
            tailDigest.update(this.buf, origCnt, this.bAvail - origCnt);
        }
        NB.encodeInt32(this.buf, 8, this.entryCount);
        this.packOut.seek(0L);
        this.packOut.write(this.buf, 0, 12);
        this.packOut.seek(this.bAvail);
        this.packDigest.reset();
        this.packDigest.update(this.buf, 0, this.bAvail);
        while ((n = this.packOut.read(this.buf)) >= 0) {
            if (origRemaining != 0L) {
                int origCnt2 = (int)Math.min((long)n, origRemaining);
                origDigest.update(this.buf, 0, origCnt2);
                if ((origRemaining -= (long)origCnt2) == 0L) {
                    tailDigest.update(this.buf, origCnt2, n - origCnt2);
                }
            } else {
                tailDigest.update(this.buf, 0, n);
            }
            this.packDigest.update(this.buf, 0, n);
        }
        if (!Arrays.equals(origDigest.digest(), origcsum) || !Arrays.equals(tailDigest.digest(), tailcsum)) {
            throw new IOException("Pack corrupted while writing to filesystem");
        }
        this.packcsum = this.packDigest.digest();
        this.packOut.write(this.packcsum);
    }

    private void growEntries() {
        PackedObjectInfo[] ne = new PackedObjectInfo[(int)this.objectCount + this.baseById.size()];
        System.arraycopy(this.entries, 0, ne, 0, this.entryCount);
        this.entries = ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIdx() throws IOException {
        Arrays.sort(this.entries, 0, this.entryCount);
        List<PackedObjectInfo> list = Arrays.asList(this.entries);
        if (this.entryCount < this.entries.length) {
            list = list.subList(0, this.entryCount);
        }
        FileOutputStream os = new FileOutputStream(this.dstIdx);
        try {
            PackIndexWriter iw = this.outputVersion <= 0 ? PackIndexWriter.createOldestPossible(os, list) : PackIndexWriter.createVersion(os, this.outputVersion);
            iw.write(list, this.packcsum);
            os.getChannel().force(true);
        }
        finally {
            os.close();
        }
    }

    private void readPackHeader() throws IOException {
        int hdrln = Constants.PACK_SIGNATURE.length + 4 + 4;
        int p = this.fillFromInput(hdrln);
        for (int k = 0; k < Constants.PACK_SIGNATURE.length; ++k) {
            if (this.buf[p + k] == Constants.PACK_SIGNATURE[k]) continue;
            throw new IOException("Not a PACK file.");
        }
        long vers = NB.decodeUInt32(this.buf, p + 4);
        if (vers != 2L && vers != 3L) {
            throw new IOException("Unsupported pack version " + vers + ".");
        }
        this.objectCount = NB.decodeUInt32(this.buf, p + 8);
        this.use(hdrln);
    }

    private void readPackFooter() throws IOException {
        this.sync();
        byte[] cmpcsum = this.packDigest.digest();
        int c = this.fillFromInput(20);
        this.packcsum = new byte[20];
        System.arraycopy(this.buf, c, this.packcsum, 0, 20);
        this.use(20);
        if (this.packOut != null) {
            this.packOut.write(this.packcsum);
        }
        if (!Arrays.equals(cmpcsum, this.packcsum)) {
            throw new CorruptObjectException("Packfile checksum incorrect.");
        }
    }

    private void endInput() {
        this.in = null;
        this.objectData = null;
    }

    private void indexOneObject() throws IOException {
        long pos = this.position();
        this.crc.reset();
        int c = this.readFromInput();
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFromInput();
            sz += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.whole(typeCode, pos, sz);
                break;
            }
            case 6: {
                c = this.readFromInput();
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = this.readFromInput();
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                Long base = new Long(pos - ofs);
                ArrayList<UnresolvedDelta> r = this.baseByPos.get(base);
                if (r == null) {
                    r = new ArrayList(8);
                    this.baseByPos.put(base, r);
                }
                this.skipInflateFromInput(sz);
                r.add(new UnresolvedDelta(pos, (int)this.crc.getValue()));
                ++this.deltaCount;
                break;
            }
            case 7: {
                c = this.fillFromInput(20);
                this.crc.update(this.buf, c, 20);
                ObjectId base = ObjectId.fromRaw(this.buf, c);
                this.use(20);
                ArrayList<UnresolvedDelta> r = this.baseById.get(base);
                if (r == null) {
                    r = new ArrayList(8);
                    this.baseById.put(base, r);
                }
                this.skipInflateFromInput(sz);
                r.add(new UnresolvedDelta(pos, (int)this.crc.getValue()));
                ++this.deltaCount;
                break;
            }
            default: {
                throw new IOException("Unknown object type " + typeCode + ".");
            }
        }
    }

    private void whole(int type, long pos, long sz) throws IOException {
        byte[] data = this.inflateFromInput(sz);
        this.objectDigest.update(Constants.encodedTypeString(type));
        this.objectDigest.update((byte)32);
        this.objectDigest.update(Constants.encodeASCII(sz));
        this.objectDigest.update((byte)0);
        this.objectDigest.update(data);
        this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
        this.verifySafeObject(this.tempObjectId, type, data);
        int crc32 = (int)this.crc.getValue();
        this.entries[this.entryCount++] = new PackedObjectInfo(pos, crc32, this.tempObjectId);
    }

    private void verifySafeObject(AnyObjectId id, int type, byte[] data) throws IOException {
        ObjectLoader ldr;
        if (this.objCheck != null) {
            try {
                this.objCheck.check(type, data);
            }
            catch (CorruptObjectException e) {
                throw new IOException("Invalid " + Constants.encodedTypeString(type) + " " + id.name() + ":" + e.getMessage());
            }
        }
        if ((ldr = this.repo.openObject(this.readCurs, id)) != null) {
            byte[] existingData = ldr.getCachedBytes();
            if (ldr.getType() != type || !Arrays.equals(data, existingData)) {
                throw new IOException("Collision on " + id.name());
            }
        }
    }

    private long position() {
        return this.bBase + (long)this.bOffset;
    }

    private void position(long pos) throws IOException {
        this.packOut.seek(pos);
        this.bBase = pos;
        this.bOffset = 0;
        this.bAvail = 0;
    }

    private int readFromInput() throws IOException {
        if (this.bAvail == 0) {
            this.fillFromInput(1);
        }
        --this.bAvail;
        int b = this.buf[this.bOffset++] & 0xFF;
        this.crc.update(b);
        return b;
    }

    private int readFromFile() throws IOException {
        if (this.bAvail == 0) {
            this.fillFromFile(1);
        }
        --this.bAvail;
        int b = this.buf[this.bOffset++] & 0xFF;
        this.crc.update(b);
        return b;
    }

    private void use(int cnt) {
        this.bOffset += cnt;
        this.bAvail -= cnt;
    }

    private int fillFromInput(int need) throws IOException {
        while (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                this.sync();
                next = this.bAvail;
                free = this.buf.length - next;
            }
            if ((next = this.in.read(this.buf, next, free)) <= 0) {
                throw new EOFException("Packfile is truncated.");
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private int fillFromFile(int need) throws IOException {
        if (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                if (this.bAvail > 0) {
                    System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
                }
                this.bOffset = 0;
                next = this.bAvail;
                free = this.buf.length - next;
            }
            if ((next = this.packOut.read(this.buf, next, free)) <= 0) {
                throw new EOFException("Packfile is truncated.");
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private void sync() throws IOException {
        this.packDigest.update(this.buf, 0, this.bOffset);
        if (this.packOut != null) {
            this.packOut.write(this.buf, 0, this.bOffset);
        }
        if (this.bAvail > 0) {
            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
        }
        this.bBase += (long)this.bOffset;
        this.bOffset = 0;
    }

    private void skipInflateFromInput(long sz) throws IOException {
        Inflater inf = this.inflater;
        try {
            byte[] dst = this.objectData;
            int n = 0;
            int p = -1;
            while (!inf.finished()) {
                int free;
                if (inf.needsInput()) {
                    if (p >= 0) {
                        this.crc.update(this.buf, p, this.bAvail);
                        this.use(this.bAvail);
                    }
                    p = this.fillFromInput(1);
                    inf.setInput(this.buf, p, this.bAvail);
                }
                if ((free = dst.length - n) < 8) {
                    sz -= (long)n;
                    n = 0;
                    free = dst.length;
                }
                n += inf.inflate(dst, n, free);
            }
            if ((long)n != sz) {
                throw new DataFormatException("wrong decompressed length");
            }
            n = this.bAvail - inf.getRemaining();
            if (n > 0) {
                this.crc.update(this.buf, p, n);
                this.use(n);
            }
        }
        catch (DataFormatException dfe) {
            throw IndexPack.corrupt(dfe);
        }
        finally {
            inf.reset();
        }
    }

    private byte[] inflateFromInput(long sz) throws IOException {
        byte[] dst = new byte[(int)sz];
        Inflater inf = this.inflater;
        try {
            int n = 0;
            int p = -1;
            while (!inf.finished()) {
                if (inf.needsInput()) {
                    if (p >= 0) {
                        this.crc.update(this.buf, p, this.bAvail);
                        this.use(this.bAvail);
                    }
                    p = this.fillFromInput(1);
                    inf.setInput(this.buf, p, this.bAvail);
                }
                n += inf.inflate(dst, n, dst.length - n);
            }
            if ((long)n != sz) {
                throw new DataFormatException("wrong decompressed length");
            }
            n = this.bAvail - inf.getRemaining();
            if (n > 0) {
                this.crc.update(this.buf, p, n);
                this.use(n);
            }
            byte[] byArray = dst;
            return byArray;
        }
        catch (DataFormatException dfe) {
            throw IndexPack.corrupt(dfe);
        }
        finally {
            inf.reset();
        }
    }

    private byte[] inflateFromFile(int sz) throws IOException {
        Inflater inf = this.inflater;
        try {
            byte[] dst = new byte[sz];
            int n = 0;
            int p = -1;
            while (!inf.finished()) {
                if (inf.needsInput()) {
                    if (p >= 0) {
                        this.crc.update(this.buf, p, this.bAvail);
                        this.use(this.bAvail);
                    }
                    p = this.fillFromFile(1);
                    inf.setInput(this.buf, p, this.bAvail);
                }
                n += inf.inflate(dst, n, sz - n);
            }
            n = this.bAvail - inf.getRemaining();
            if (n > 0) {
                this.crc.update(this.buf, p, n);
                this.use(n);
            }
            byte[] byArray = dst;
            return byArray;
        }
        catch (DataFormatException dfe) {
            throw IndexPack.corrupt(dfe);
        }
        finally {
            inf.reset();
        }
    }

    private static CorruptObjectException corrupt(DataFormatException dfe) {
        return new CorruptObjectException("Packfile corruption detected: " + dfe.getMessage());
    }

    public void renameAndOpenPack() throws IOException {
        if (!this.keepEmpty && this.entryCount == 0) {
            this.cleanupTemporaryFiles();
            return;
        }
        MessageDigest d = Constants.newMessageDigest();
        byte[] oeBytes = new byte[20];
        for (int i = 0; i < this.entryCount; ++i) {
            PackedObjectInfo oe = this.entries[i];
            oe.copyRawTo(oeBytes, 0);
            d.update(oeBytes);
        }
        String name = ObjectId.fromRaw(d.digest()).name();
        File packDir = new File(this.repo.getObjectsDirectory(), "pack");
        File finalPack = new File(packDir, "pack-" + name + ".pack");
        File finalIdx = new File(packDir, "pack-" + name + ".idx");
        if (finalPack.exists()) {
            this.cleanupTemporaryFiles();
            return;
        }
        if (!this.dstPack.renameTo(finalPack)) {
            this.cleanupTemporaryFiles();
            throw new IOException("Cannot move pack to " + finalPack);
        }
        if (!this.dstIdx.renameTo(finalIdx)) {
            this.cleanupTemporaryFiles();
            if (!finalPack.delete()) {
                finalPack.deleteOnExit();
            }
            throw new IOException("Cannot move index to " + finalIdx);
        }
        try {
            this.repo.openPack(finalPack, finalIdx);
        }
        catch (IOException err) {
            finalPack.delete();
            finalIdx.delete();
            throw err;
        }
    }

    private void cleanupTemporaryFiles() {
        if (!this.dstIdx.delete()) {
            this.dstIdx.deleteOnExit();
        }
        if (!this.dstPack.delete()) {
            this.dstPack.deleteOnExit();
        }
    }

    private static class UnresolvedDelta {
        final long position;
        final int crc;

        UnresolvedDelta(long headerOffset, int crc32) {
            this.position = headerOffset;
            this.crc = crc32;
        }
    }
}

