/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.transport.TrackingRefUpdate;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationResult {
    protected Map<String, Ref> advertisedRefs = Collections.emptyMap();
    protected URIish uri;
    protected final SortedMap<String, TrackingRefUpdate> updates = new TreeMap<String, TrackingRefUpdate>();

    public URIish getURI() {
        return this.uri;
    }

    public Collection<Ref> getAdvertisedRefs() {
        return Collections.unmodifiableCollection(this.advertisedRefs.values());
    }

    public final Ref getAdvertisedRef(String name) {
        return this.advertisedRefs.get(name);
    }

    public Collection<TrackingRefUpdate> getTrackingRefUpdates() {
        return Collections.unmodifiableCollection(this.updates.values());
    }

    public TrackingRefUpdate getTrackingRefUpdate(String localName) {
        return (TrackingRefUpdate)this.updates.get(localName);
    }

    protected void setAdvertisedRefs(URIish u, Map<String, Ref> ar) {
        this.uri = u;
        this.advertisedRefs = ar;
    }

    protected void add(TrackingRefUpdate u) {
        this.updates.put(u.getLocalName(), u);
    }
}

