/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.MutableObjectId;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.transport.SideBandInputStream;
import org.spearce.jgit.util.NB;
import org.spearce.jgit.util.RawParseUtils;

class PacketLineIn {
    private static final byte[] fromhex;
    private final InputStream in;
    private final byte[] lenbuffer;

    PacketLineIn(InputStream i) {
        this.in = i;
        this.lenbuffer = new byte[4];
    }

    InputStream sideband(ProgressMonitor pm) {
        return new SideBandInputStream(this, this.in, pm);
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line = this.readString();
        if (line.length() == 0) {
            throw new PackProtocolException("Expected ACK/NAK, found EOF");
        }
        if ("NAK".equals(line)) {
            return AckNackResult.NAK;
        }
        if (line.startsWith("ACK ")) {
            returnedId.fromString(line.substring(4, 44));
            if (line.indexOf("continue", 44) != -1) {
                return AckNackResult.ACK_CONTINUE;
            }
            return AckNackResult.ACK;
        }
        throw new PackProtocolException("Expected ACK/NAK, got: " + line);
    }

    String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return "";
        }
        byte[] raw = new byte[len -= 5];
        NB.readFully(this.in, raw, 0, len);
        this.readLF();
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    String readStringNoLF() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return "";
        }
        byte[] raw = new byte[len -= 4];
        NB.readFully(this.in, raw, 0, len);
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    private void readLF() throws IOException {
        if (this.in.read() != 10) {
            throw new IOException("Protocol error: expected LF");
        }
    }

    int readLength() throws IOException {
        NB.readFully(this.in, this.lenbuffer, 0, 4);
        try {
            int r = fromhex[this.lenbuffer[0]] << 4;
            r |= fromhex[this.lenbuffer[1]];
            r <<= 4;
            r |= fromhex[this.lenbuffer[2]];
            r <<= 4;
            if ((r |= fromhex[this.lenbuffer[3]]) < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return r;
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new IOException("Invalid packet line header: " + (char)this.lenbuffer[0] + (char)this.lenbuffer[1] + (char)this.lenbuffer[2] + (char)this.lenbuffer[3]);
        }
    }

    static {
        int i;
        fromhex = new byte[103];
        Arrays.fill(fromhex, (byte)-1);
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            PacketLineIn.fromhex[i] = (byte)(i - 48);
        }
        for (i = 97; i <= 102; i = (int)((char)(i + 1))) {
            PacketLineIn.fromhex[i] = (byte)(i - 97 + 10);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE;

    }
}

