/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.spearce.jgit.lib.Constants;

class PacketLineOut {
    private final OutputStream out;
    private final byte[] lenbuffer;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    PacketLineOut(OutputStream i) {
        this.out = i;
        this.lenbuffer = new byte[5];
    }

    void writeString(String s) throws IOException {
        this.writePacket(Constants.encode(s));
    }

    void writePacket(byte[] packet) throws IOException {
        this.formatLength(packet.length + 4);
        this.out.write(this.lenbuffer, 0, 4);
        this.out.write(packet);
    }

    void writeChannelPacket(int channel, byte[] buf, int off, int len) throws IOException {
        this.formatLength(len + 5);
        this.lenbuffer[4] = (byte)channel;
        this.out.write(this.lenbuffer, 0, 5);
        this.out.write(buf, off, len);
    }

    void end() throws IOException {
        this.formatLength(0);
        this.out.write(this.lenbuffer, 0, 4);
        this.flush();
    }

    void flush() throws IOException {
        this.out.flush();
    }

    private void formatLength(int w) {
        int o = 3;
        while (o >= 0 && w != 0) {
            this.lenbuffer[o--] = hexchar[w & 0xF];
            w >>>= 4;
        }
        while (o >= 0) {
            this.lenbuffer[o--] = 48;
        }
    }
}

