/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.PushResult;
import org.spearce.jgit.transport.RemoteRefUpdate;
import org.spearce.jgit.transport.TrackingRefUpdate;
import org.spearce.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushProcess {
    static final String PROGRESS_OPENING_CONNECTION = "Opening connection";
    private final Transport transport;
    private PushConnection connection;
    private final Map<String, RemoteRefUpdate> toPush;
    private final RevWalk walker;

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush) throws TransportException {
        this.walker = new RevWalk(transport.local);
        this.transport = transport;
        this.toPush = new HashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : toPush) {
            if (this.toPush.put(rru.getRemoteName(), rru) == null) continue;
            throw new TransportException("Duplicate remote ref update is illegal. Affected remote name: " + rru.getRemoteName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PushResult execute(ProgressMonitor monitor) throws NotSupportedException, TransportException {
        monitor.beginTask(PROGRESS_OPENING_CONNECTION, 0);
        this.connection = this.transport.openPush();
        try {
            monitor.endTask();
            Map<String, RemoteRefUpdate> preprocessed = this.prepareRemoteUpdates();
            if (this.transport.isDryRun()) {
                this.modifyUpdatesForDryRun();
            } else if (!preprocessed.isEmpty()) {
                this.connection.push(monitor, preprocessed);
            }
        }
        finally {
            this.connection.close();
        }
        if (!this.transport.isDryRun()) {
            this.updateTrackingRefs();
        }
        return this.prepareOperationResult();
    }

    private Map<String, RemoteRefUpdate> prepareRemoteUpdates() throws TransportException {
        HashMap<String, RemoteRefUpdate> result = new HashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : this.toPush.values()) {
            ObjectId advertisedOld;
            Ref advertisedRef = this.connection.getRef(rru.getRemoteName());
            ObjectId objectId = advertisedOld = advertisedRef == null ? ObjectId.zeroId() : advertisedRef.getObjectId();
            if (rru.getNewObjectId().equals(advertisedOld)) {
                if (rru.isDelete()) {
                    rru.setStatus(RemoteRefUpdate.Status.NON_EXISTING);
                    continue;
                }
                rru.setStatus(RemoteRefUpdate.Status.UP_TO_DATE);
                continue;
            }
            if (rru.isExpectingOldObjectId() && !rru.getExpectedOldObjectId().equals(advertisedOld)) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED);
                continue;
            }
            if (advertisedOld.equals(ObjectId.zeroId()) || rru.isDelete()) {
                rru.setFastForward(true);
                result.put(rru.getRemoteName(), rru);
                continue;
            }
            boolean fastForward = true;
            try {
                RevObject oldRev = this.walker.parseAny(advertisedOld);
                RevObject newRev = this.walker.parseAny(rru.getNewObjectId());
                if (!(oldRev instanceof RevCommit && newRev instanceof RevCommit && this.walker.isMergedInto((RevCommit)oldRev, (RevCommit)newRev))) {
                    fastForward = false;
                }
            }
            catch (MissingObjectException x) {
                fastForward = false;
            }
            catch (Exception x) {
                throw new TransportException(this.transport.getURI(), "reading objects from local repository failed: " + x.getMessage(), x);
            }
            rru.setFastForward(fastForward);
            if (!fastForward && !rru.isForceUpdate()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD);
                continue;
            }
            result.put(rru.getRemoteName(), rru);
        }
        return result;
    }

    private void modifyUpdatesForDryRun() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.OK);
        }
    }

    private void updateTrackingRefs() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            RemoteRefUpdate.Status status = rru.getStatus();
            if (!rru.hasTrackingRefUpdate() || status != RemoteRefUpdate.Status.UP_TO_DATE && status != RemoteRefUpdate.Status.OK) continue;
            try {
                rru.updateTrackingRef(this.walker);
            }
            catch (IOException e) {}
        }
    }

    private PushResult prepareOperationResult() {
        PushResult result = new PushResult();
        result.setAdvertisedRefs(this.transport.getURI(), this.connection.getRefsMap());
        result.setRemoteUpdates(this.toPush);
        for (RemoteRefUpdate rru : this.toPush.values()) {
            TrackingRefUpdate tru = rru.getTrackingRefUpdate();
            if (tru == null) continue;
            result.add(tru);
        }
        return result;
    }
}

