/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.NullProgressMonitor;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefComparator;
import org.spearce.jgit.lib.RefUpdate;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.revwalk.ObjectWalk;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.IndexPack;
import org.spearce.jgit.transport.PacketLineIn;
import org.spearce.jgit.transport.PacketLineOut;
import org.spearce.jgit.transport.PostReceiveHook;
import org.spearce.jgit.transport.PreReceiveHook;
import org.spearce.jgit.transport.ReceiveCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivePack {
    static final String CAPABILITY_REPORT_STATUS = "report-status";
    static final String CAPABILITY_DELETE_REFS = "delete-refs";
    private final Repository db;
    private final RevWalk walk;
    private boolean checkReceivedObjects;
    private boolean allowCreates;
    private boolean allowDeletes;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private PreReceiveHook preReceive;
    private PostReceiveHook postReceive;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private PrintWriter msgs;
    private Map<String, Ref> refs;
    private Set<String> enabledCapablities;
    private List<ReceiveCommand> commands;
    private Throwable unpackError;
    private boolean reportStatus;

    public ReceivePack(Repository into) {
        this.db = into;
        this.walk = new RevWalk(this.db);
        RepositoryConfig cfg = this.db.getConfig();
        this.checkReceivedObjects = cfg.getBoolean("receive", "fsckobjects", false);
        this.allowCreates = true;
        this.allowDeletes = !cfg.getBoolean("receive", "denydeletes", false);
        this.allowNonFastForwards = !cfg.getBoolean("receive", "denynonfastforwards", false);
        this.preReceive = PreReceiveHook.NULL;
        this.postReceive = PostReceiveHook.NULL;
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public boolean isCheckReceivedObjects() {
        return this.checkReceivedObjects;
    }

    public void setCheckReceivedObjects(boolean check) {
        this.checkReceivedObjects = check;
    }

    public boolean isAllowCreates() {
        return this.allowCreates;
    }

    public void setAllowCreates(boolean canCreate) {
        this.allowCreates = canCreate;
    }

    public boolean isAllowDeletes() {
        return this.allowDeletes;
    }

    public void setAllowDeletes(boolean canDelete) {
        this.allowDeletes = canDelete;
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public void setAllowNonFastForwards(boolean canRewind) {
        this.allowNonFastForwards = canRewind;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h) {
        this.preReceive = h != null ? h : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h) {
        this.postReceive = h != null ? h : PostReceiveHook.NULL;
    }

    public List<ReceiveCommand> getAllCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void sendError(String what) {
        this.sendMessage("error", what);
    }

    public void sendMessage(String what) {
        this.sendMessage("remote", what);
    }

    private void sendMessage(String type, String what) {
        if (this.msgs != null) {
            this.msgs.println(type + ": " + what);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        try {
            this.rawIn = input;
            this.rawOut = output;
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            if (messages != null) {
                this.msgs = new PrintWriter(new BufferedWriter(new OutputStreamWriter(messages, Constants.CHARSET), 8192)){

                    public void println() {
                        this.print('\n');
                    }
                };
            }
            this.enabledCapablities = new HashSet<String>();
            this.commands = new ArrayList<ReceiveCommand>();
            this.service();
        }
        finally {
            try {
                if (this.msgs != null) {
                    this.msgs.flush();
                }
            }
            finally {
                this.rawIn = null;
                this.rawOut = null;
                this.pckIn = null;
                this.pckOut = null;
                this.msgs = null;
                this.refs = null;
                this.enabledCapablities = null;
                this.commands = null;
            }
        }
    }

    private void service() throws IOException {
        this.sendAdvertisedRefs();
        this.recvCommands();
        if (!this.commands.isEmpty()) {
            this.enableCapabilities();
            if (this.needPack()) {
                try {
                    this.receivePack();
                    if (this.isCheckReceivedObjects()) {
                        this.checkConnectivity();
                    }
                    this.unpackError = null;
                }
                catch (IOException err) {
                    this.unpackError = err;
                }
                catch (RuntimeException err) {
                    this.unpackError = err;
                }
                catch (Error err) {
                    this.unpackError = err;
                }
            }
            if (this.unpackError == null) {
                this.validateCommands();
                this.executeCommands();
            }
            if (this.reportStatus) {
                this.sendStatusReport(true, new Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.pckOut.writeString(s + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgs != null) {
                this.sendStatusReport(false, new Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.msgs.println(s);
                    }
                });
                this.msgs.flush();
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
        }
    }

    private void sendAdvertisedRefs() throws IOException {
        Ref r;
        this.refs = this.db.getAllRefs();
        StringBuilder m = new StringBuilder(100);
        char[] idtmp = new char[40];
        Iterator<Ref> i = RefComparator.sort(this.refs.values()).iterator();
        if (i.hasNext()) {
            r = i.next();
            this.format(m, idtmp, r.getObjectId(), r.getOrigName());
        } else {
            this.format(m, idtmp, ObjectId.zeroId(), "capabilities^{}");
        }
        m.append('\u0000');
        m.append(' ');
        m.append(CAPABILITY_DELETE_REFS);
        m.append(' ');
        m.append(CAPABILITY_REPORT_STATUS);
        m.append(' ');
        this.writeAdvertisedRef(m);
        while (i.hasNext()) {
            r = i.next();
            this.format(m, idtmp, r.getObjectId(), r.getOrigName());
            this.writeAdvertisedRef(m);
        }
        this.pckOut.end();
    }

    private void format(StringBuilder m, char[] idtmp, ObjectId id, String name) {
        m.setLength(0);
        id.copyTo(idtmp, m);
        m.append(' ');
        m.append(name);
    }

    private void writeAdvertisedRef(StringBuilder m) throws IOException {
        m.append('\n');
        this.pckOut.writeString(m.toString());
    }

    private void recvCommands() throws IOException {
        while (true) {
            int nul;
            String line;
            try {
                line = this.pckIn.readStringNoLF();
            }
            catch (EOFException eof) {
                if (this.commands.isEmpty()) {
                    return;
                }
                throw eof;
            }
            if (this.commands.isEmpty() && (nul = line.indexOf(0)) >= 0) {
                for (String c : line.substring(nul + 1).split(" ")) {
                    this.enabledCapablities.add(c);
                }
                line = line.substring(0, nul);
            }
            if (line.length() == 0) break;
            if (line.length() < 83) {
                String m = "error: invalid protocol: wanted 'old new ref'";
                this.sendError("error: invalid protocol: wanted 'old new ref'");
                throw new PackProtocolException("error: invalid protocol: wanted 'old new ref'");
            }
            ObjectId oldId = ObjectId.fromString(line.substring(0, 40));
            ObjectId newId = ObjectId.fromString(line.substring(41, 81));
            String name = line.substring(82);
            ReceiveCommand cmd = new ReceiveCommand(oldId, newId, name);
            cmd.setRef(this.refs.get(cmd.getRefName()));
            this.commands.add(cmd);
        }
    }

    private void enableCapabilities() {
        this.reportStatus = this.enabledCapablities.contains(CAPABILITY_REPORT_STATUS);
    }

    private boolean needPack() {
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            return true;
        }
        return false;
    }

    private void receivePack() throws IOException {
        IndexPack ip = IndexPack.create(this.db, this.rawIn);
        ip.setFixThin(true);
        ip.setObjectChecking(this.isCheckReceivedObjects());
        ip.index(NullProgressMonitor.INSTANCE);
        ip.renameAndOpenPack();
    }

    private void checkConnectivity() throws IOException {
        ObjectWalk ow = new ObjectWalk(this.db);
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            ow.markStart(ow.parseAny(cmd.getNewId()));
        }
        for (Ref ref : this.refs.values()) {
            ow.markUninteresting(ow.parseAny(ref.getObjectId()));
        }
        ow.checkConnectivity();
    }

    private void validateCommands() {
        for (ReceiveCommand cmd : this.commands) {
            Ref ref = cmd.getRef();
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            if (cmd.getType() == ReceiveCommand.Type.DELETE && !this.isAllowDeletes()) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                continue;
            }
            if (cmd.getType() == ReceiveCommand.Type.CREATE) {
                if (!this.isAllowCreates()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NOCREATE);
                    continue;
                }
                if (ref != null && !this.isAllowNonFastForwards()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
                if (ref != null) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "ref exists");
                    continue;
                }
            }
            if (cmd.getType() == ReceiveCommand.Type.DELETE && ref != null && !ObjectId.zeroId().equals(cmd.getOldId()) && !ref.getObjectId().equals(cmd.getOldId())) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "invalid old id sent");
                continue;
            }
            if (cmd.getType() == ReceiveCommand.Type.UPDATE) {
                RevObject newObj;
                RevObject oldObj;
                if (ref == null) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "no such ref");
                    continue;
                }
                if (!ref.getObjectId().equals(cmd.getOldId())) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "invalid old id sent");
                    continue;
                }
                try {
                    oldObj = this.walk.parseAny(cmd.getOldId());
                }
                catch (IOException e) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getOldId().name());
                    continue;
                }
                try {
                    newObj = this.walk.parseAny(cmd.getNewId());
                }
                catch (IOException e) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getNewId().name());
                    continue;
                }
                if (oldObj instanceof RevCommit && newObj instanceof RevCommit) {
                    try {
                        if (!this.walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) {
                            cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                        }
                    }
                    catch (MissingObjectException e) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, e.getMessage());
                    }
                    catch (IOException e) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON);
                    }
                } else {
                    cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                }
            }
            if (cmd.getRefName().startsWith("refs/") && Repository.isValidRefName(cmd.getRefName())) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "funny refname");
        }
    }

    private void executeCommands() {
        this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
        for (ReceiveCommand cmd : this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED)) {
            this.execute(cmd);
        }
    }

    private void execute(ReceiveCommand cmd) {
        try {
            RefUpdate ru = this.db.updateRef(cmd.getRefName());
            ru.setRefLogIdent(this.getRefLogIdent());
            switch (cmd.getType()) {
                case DELETE: {
                    if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                        ru.setExpectedOldObjectId(cmd.getOldId());
                    }
                    ru.setForceUpdate(true);
                    this.status(cmd, ru.delete(this.walk));
                    break;
                }
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    ru.setForceUpdate(this.isAllowNonFastForwards());
                    ru.setExpectedOldObjectId(cmd.getOldId());
                    ru.setNewObjectId(cmd.getNewId());
                    ru.setRefLogMessage("push", true);
                    this.status(cmd, ru.update(this.walk));
                }
            }
        }
        catch (IOException err) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "lock error: " + err.getMessage());
        }
    }

    private void status(ReceiveCommand cmd, RefUpdate.Result result) {
        switch (result) {
            case NOT_ATTEMPTED: {
                cmd.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                cmd.setResult(ReceiveCommand.Result.OK);
                break;
            }
            case REJECTED: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            default: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, result.name());
            }
        }
    }

    private List<ReceiveCommand> filterCommands(ReceiveCommand.Result want) {
        ArrayList<ReceiveCommand> r = new ArrayList<ReceiveCommand>(this.commands.size());
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() != want) continue;
            r.add(cmd);
        }
        return r;
    }

    private void sendStatusReport(boolean forClient, Reporter out) throws IOException {
        if (this.unpackError != null) {
            out.sendString("unpack error " + this.unpackError.getMessage());
            if (forClient) {
                for (ReceiveCommand cmd : this.commands) {
                    out.sendString("ng " + cmd.getRefName() + " n/a (unpacker error)");
                }
            }
            return;
        }
        if (forClient) {
            out.sendString("unpack ok");
        }
        block12: for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) {
                if (!forClient) continue;
                out.sendString("ok " + cmd.getRefName());
                continue;
            }
            StringBuilder r = new StringBuilder();
            r.append("ng ");
            r.append(cmd.getRefName());
            r.append(" ");
            switch (cmd.getResult()) {
                case NOT_ATTEMPTED: {
                    r.append("server bug; ref not processed");
                    break;
                }
                case REJECTED_NOCREATE: {
                    r.append("creation prohibited");
                    break;
                }
                case REJECTED_NODELETE: {
                    r.append("deletion prohibited");
                    break;
                }
                case REJECTED_NONFASTFORWARD: {
                    r.append("non-fast forward");
                    break;
                }
                case REJECTED_CURRENT_BRANCH: {
                    r.append("branch is currently checked out");
                    break;
                }
                case REJECTED_MISSING_OBJECT: {
                    if (cmd.getMessage() == null) {
                        r.append("missing object(s)");
                        break;
                    }
                    if (cmd.getMessage().length() == 40) {
                        r.append("object " + cmd.getMessage() + " missing");
                        break;
                    }
                    r.append(cmd.getMessage());
                    break;
                }
                case REJECTED_OTHER_REASON: {
                    if (cmd.getMessage() == null) {
                        r.append("unspecified reason");
                        break;
                    }
                    r.append(cmd.getMessage());
                    break;
                }
                case LOCK_FAILURE: {
                    r.append("failed to lock");
                    break;
                }
                case OK: {
                    continue block12;
                }
            }
            out.sendString(r.toString());
        }
    }

    static abstract class Reporter {
        Reporter() {
        }

        abstract void sendString(String var1) throws IOException;
    }
}

