/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.TagOpt;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConfig
implements Externalizable {
    private static final String SECTION = "remote";
    private static final String KEY_URL = "url";
    private static final String KEY_FETCH = "fetch";
    private static final String KEY_PUSH = "push";
    private static final String KEY_UPLOADPACK = "uploadpack";
    private static final String KEY_RECEIVEPACK = "receivepack";
    private static final String KEY_TAGOPT = "tagopt";
    public static final String DEFAULT_UPLOAD_PACK = "git-upload-pack";
    public static final String DEFAULT_RECEIVE_PACK = "git-receive-pack";
    private String name;
    private List<URIish> uris;
    private List<RefSpec> fetch;
    private List<RefSpec> push;
    private String uploadpack;
    private String receivepack;
    private TagOpt tagopt;

    public static List<RemoteConfig> getAllRemoteConfigs(RepositoryConfig rc) throws URISyntaxException {
        ArrayList<String> names = new ArrayList<String>(rc.getSubsections(SECTION));
        Collections.sort(names);
        ArrayList<RemoteConfig> result = new ArrayList<RemoteConfig>(names.size());
        for (String name : names) {
            result.add(new RemoteConfig(rc, name));
        }
        return result;
    }

    public RemoteConfig(RepositoryConfig rc, String remoteName) throws URISyntaxException {
        this.name = remoteName;
        String[] vlst = rc.getStringList(SECTION, this.name, KEY_URL);
        this.uris = new ArrayList<URIish>(vlst.length);
        for (String s : vlst) {
            this.uris.add(new URIish(s));
        }
        vlst = rc.getStringList(SECTION, this.name, KEY_FETCH);
        this.fetch = new ArrayList<RefSpec>(vlst.length);
        for (String s : vlst) {
            this.fetch.add(new RefSpec(s));
        }
        vlst = rc.getStringList(SECTION, this.name, KEY_PUSH);
        this.push = new ArrayList<RefSpec>(vlst.length);
        for (String s : vlst) {
            this.push.add(new RefSpec(s));
        }
        String val = rc.getString(SECTION, this.name, KEY_UPLOADPACK);
        if (val == null) {
            val = DEFAULT_UPLOAD_PACK;
        }
        this.uploadpack = val;
        val = rc.getString(SECTION, this.name, KEY_RECEIVEPACK);
        if (val == null) {
            val = DEFAULT_RECEIVE_PACK;
        }
        this.receivepack = val;
        val = rc.getString(SECTION, this.name, KEY_TAGOPT);
        this.tagopt = TagOpt.fromOption(val);
    }

    public RemoteConfig() {
        this.uris = new ArrayList<URIish>();
        this.fetch = new ArrayList<RefSpec>();
        this.push = new ArrayList<RefSpec>();
        this.uploadpack = DEFAULT_UPLOAD_PACK;
        this.receivepack = DEFAULT_RECEIVE_PACK;
    }

    public void update(RepositoryConfig rc) {
        ArrayList<String> vlst = new ArrayList<String>();
        vlst.clear();
        for (URIish uRIish : this.getURIs()) {
            vlst.add(uRIish.toPrivateString());
        }
        rc.setStringList(SECTION, this.getName(), KEY_URL, vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getFetchRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc.setStringList(SECTION, this.getName(), KEY_FETCH, vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getPushRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc.setStringList(SECTION, this.getName(), KEY_PUSH, vlst);
        this.set(rc, KEY_UPLOADPACK, this.getUploadPack(), DEFAULT_UPLOAD_PACK);
        this.set(rc, KEY_RECEIVEPACK, this.getReceivePack(), DEFAULT_RECEIVE_PACK);
        this.set(rc, KEY_TAGOPT, this.getTagOpt().option(), TagOpt.AUTO_FOLLOW.option());
    }

    private void set(RepositoryConfig rc, String key, String currentValue, String defaultValue) {
        if (defaultValue.equals(currentValue)) {
            rc.unsetString(SECTION, this.getName(), key);
        } else {
            rc.setString(SECTION, this.getName(), key, currentValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<URIish> getURIs() {
        return Collections.unmodifiableList(this.uris);
    }

    public boolean addURI(URIish toAdd) {
        if (this.uris.contains(toAdd)) {
            return false;
        }
        return this.uris.add(toAdd);
    }

    public boolean removeURI(URIish toRemove) {
        return this.uris.remove(toRemove);
    }

    public List<RefSpec> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetch);
    }

    public boolean addFetchRefSpec(RefSpec s) {
        if (this.fetch.contains(s)) {
            return false;
        }
        return this.fetch.add(s);
    }

    public void setFetchRefSpecs(List<RefSpec> specs) {
        this.fetch.clear();
        this.fetch.addAll(specs);
    }

    public void setPushRefSpecs(List<RefSpec> specs) {
        this.push.clear();
        this.push.addAll(specs);
    }

    public boolean removeFetchRefSpec(RefSpec s) {
        return this.fetch.remove(s);
    }

    public List<RefSpec> getPushRefSpecs() {
        return Collections.unmodifiableList(this.push);
    }

    public boolean addPushRefSpec(RefSpec s) {
        if (this.push.contains(s)) {
            return false;
        }
        return this.push.add(s);
    }

    public boolean removePushRefSpec(RefSpec s) {
        return this.push.remove(s);
    }

    public String getUploadPack() {
        return this.uploadpack;
    }

    public String getReceivePack() {
        return this.receivepack;
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    private Map<String, Collection<String>> toMap() {
        ArrayList<String> values;
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        if (this.uris.size() > 0) {
            values = new ArrayList<String>();
            for (URIish uri : this.uris) {
                values.add(uri.toPrivateString());
            }
            map.put(KEY_URL, values);
        }
        if (this.fetch.size() > 0) {
            values = new ArrayList();
            for (RefSpec refspec : this.fetch) {
                values.add(refspec.toString());
            }
            map.put(KEY_FETCH, values);
        }
        if (this.push.size() > 0) {
            values = new ArrayList();
            for (RefSpec refspec : this.push) {
                values.add(refspec.toString());
            }
            map.put(KEY_PUSH, values);
        }
        ArrayList<String> uploads = new ArrayList<String>(1);
        uploads.add(this.uploadpack);
        map.put(KEY_UPLOADPACK, uploads);
        ArrayList<String> receives = new ArrayList<String>(1);
        receives.add(this.uploadpack);
        map.put(KEY_RECEIVEPACK, receives);
        ArrayList<String> tag = new ArrayList<String>(1);
        tag.add(this.tagopt.option());
        map.put(KEY_TAGOPT, tag);
        return map;
    }

    private void fromMap(Map<String, Collection<String>> map) throws URISyntaxException {
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            Iterator<String> i$;
            String value2;
            String key = entry.getKey();
            if (key.equals(KEY_URL)) {
                for (String value2 : entry.getValue()) {
                    this.uris.add(new URIish(value2));
                }
                continue;
            }
            if (key.equals(KEY_FETCH)) {
                for (String value2 : entry.getValue()) {
                    this.fetch.add(new RefSpec(value2));
                }
                continue;
            }
            if (key.equals(KEY_PUSH)) {
                for (String value2 : entry.getValue()) {
                    this.push.add(new RefSpec(value2));
                }
                continue;
            }
            if (key.equals(KEY_UPLOADPACK)) {
                i$ = entry.getValue().iterator();
                while (i$.hasNext()) {
                    this.uploadpack = value2 = i$.next();
                }
                continue;
            }
            if (key.equals(KEY_RECEIVEPACK)) {
                i$ = entry.getValue().iterator();
                while (i$.hasNext()) {
                    this.receivepack = value2 = i$.next();
                }
                continue;
            }
            if (!key.equals(KEY_TAGOPT)) continue;
            for (String value2 : entry.getValue()) {
                this.tagopt = TagOpt.fromOption(value2);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int items = in.readInt();
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (int i = 0; i < items; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            ArrayList<String> values = (ArrayList<String>)map.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                map.put(key, values);
            }
            values.add(value);
        }
        try {
            this.fromMap(map);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Problem reading RemoteConfig map");
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Map<String, Collection<String>> map = this.toMap();
        out.writeUTF(this.name);
        out.writeInt(map.size());
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            for (String value : entry.getValue()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(value);
            }
        }
    }
}

