/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.TrackingRefUpdate;

public class RemoteRefUpdate {
    private final ObjectId expectedOldObjectId;
    private final ObjectId newObjectId;
    private final String remoteName;
    private final TrackingRefUpdate trackingRefUpdate;
    private final String srcRef;
    private final boolean forceUpdate;
    private Status status;
    private boolean fastForward;
    private String message;
    private final Repository localDb;

    public RemoteRefUpdate(Repository localDb, String srcRef, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        if (remoteName == null) {
            throw new IllegalArgumentException("Remote name can't be null.");
        }
        this.srcRef = srcRef;
        ObjectId objectId = this.newObjectId = srcRef == null ? ObjectId.zeroId() : localDb.resolve(srcRef);
        if (this.newObjectId == null) {
            throw new IOException("Source ref " + srcRef + " doesn't resolve to any object.");
        }
        this.remoteName = remoteName;
        this.forceUpdate = forceUpdate;
        this.trackingRefUpdate = localName != null && localDb != null ? new TrackingRefUpdate(localDb, localName, remoteName, true, this.newObjectId, "push") : null;
        this.localDb = localDb;
        this.expectedOldObjectId = expectedOldObjectId;
        this.status = Status.NOT_ATTEMPTED;
    }

    public RemoteRefUpdate(RemoteRefUpdate base, ObjectId newExpectedOldObjectId) throws IOException {
        this(base.localDb, base.srcRef, base.remoteName, base.forceUpdate, base.trackingRefUpdate == null ? null : base.trackingRefUpdate.getLocalName(), newExpectedOldObjectId);
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expectedOldObjectId;
    }

    public boolean isExpectingOldObjectId() {
        return this.expectedOldObjectId != null;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public boolean isDelete() {
        return ObjectId.zeroId().equals(this.newObjectId);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public TrackingRefUpdate getTrackingRefUpdate() {
        return this.trackingRefUpdate;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public boolean hasTrackingRefUpdate() {
        return this.trackingRefUpdate != null;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setStatus(Status status) {
        this.status = status;
    }

    protected void setFastForward(boolean fastForward) {
        this.fastForward = fastForward;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected void updateTrackingRef(RevWalk walk) throws IOException {
        if (this.isDelete()) {
            this.trackingRefUpdate.delete(walk);
        } else {
            this.trackingRefUpdate.update(walk);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_ATTEMPTED,
        UP_TO_DATE,
        REJECTED_NONFASTFORWARD,
        REJECTED_NODELETE,
        REJECTED_REMOTE_CHANGED,
        REJECTED_OTHER_REASON,
        NON_EXISTING,
        AWAITING_REPORT,
        OK;

    }
}

