/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.transport.PacketLineIn;
import org.spearce.jgit.util.NB;
import org.spearce.jgit.util.RawParseUtils;

class SideBandInputStream
extends InputStream {
    static final int CH_DATA = 1;
    static final int CH_PROGRESS = 2;
    static final int CH_ERROR = 3;
    private static Pattern P_UNBOUNDED = Pattern.compile("^([\\w ]+): (\\d+)( |, done)?.*", 32);
    private static Pattern P_BOUNDED = Pattern.compile("^([\\w ]+):.*\\((\\d+)/(\\d+)\\).*", 32);
    private final PacketLineIn pckIn;
    private final InputStream in;
    private final ProgressMonitor monitor;
    private String progressBuffer = "";
    private String currentTask;
    private int lastCnt;
    private boolean eof;
    private int channel;
    private int available;

    SideBandInputStream(PacketLineIn aPckIn, InputStream aIn, ProgressMonitor aProgress) {
        this.pckIn = aPckIn;
        this.in = aIn;
        this.monitor = aProgress;
        this.currentTask = "";
    }

    public int read() throws IOException {
        this.needDataPacket();
        if (this.eof) {
            return -1;
        }
        --this.available;
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        while (len > 0) {
            int n;
            this.needDataPacket();
            if (this.eof || (n = this.in.read(b, off, Math.min(len, this.available))) < 0) break;
            r += n;
            off += n;
            len -= n;
            this.available -= n;
        }
        return this.eof && r == 0 ? -1 : r;
    }

    private void needDataPacket() throws IOException {
        if (this.eof || this.channel == 1 && this.available > 0) {
            return;
        }
        block5: while (true) {
            this.available = this.pckIn.readLength();
            if (this.available == 0) {
                this.eof = true;
                return;
            }
            this.channel = this.in.read();
            this.available -= 5;
            if (this.available == 0) continue;
            switch (this.channel) {
                case 1: {
                    return;
                }
                case 2: {
                    this.progress(this.readString(this.available));
                    continue block5;
                }
                case 3: {
                    this.eof = true;
                    throw new TransportException("remote: " + this.readString(this.available));
                }
            }
            break;
        }
        throw new PackProtocolException("Invalid channel " + this.channel);
    }

    private void progress(String pkt) {
        pkt = this.progressBuffer + pkt;
        while (true) {
            int s;
            int lf = pkt.indexOf(10);
            int cr = pkt.indexOf(13);
            if (0 <= lf && 0 <= cr) {
                s = Math.min(lf, cr);
            } else if (0 <= lf) {
                s = lf;
            } else {
                if (0 > cr) break;
                s = cr;
            }
            String msg = pkt.substring(0, s);
            if (!this.doProgressLine(msg)) break;
            pkt = pkt.substring(s + 1);
        }
        this.progressBuffer = pkt;
    }

    private boolean doProgressLine(String msg) {
        Matcher matcher = P_BOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                int tot = Integer.parseInt(matcher.group(3));
                this.monitor.beginTask(this.currentTask, tot);
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return true;
        }
        matcher = P_UNBOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                this.monitor.beginTask(this.currentTask, 0);
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return true;
        }
        return false;
    }

    private String readString(int len) throws IOException {
        byte[] raw = new byte[len];
        NB.readFully(this.in, raw, 0, len);
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }
}

