/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.transport.PacketLineOut;
import org.spearce.jgit.transport.SideBandOutputStream;

class SideBandProgressMonitor
implements ProgressMonitor {
    private PrintWriter out;
    private boolean output;
    private long taskBeganAt;
    private long lastOutput;
    private String msg;
    private int lastWorked;
    private int totalWork;

    SideBandProgressMonitor(PacketLineOut pckOut) {
        int bufsz = 995;
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new SideBandOutputStream(2, pckOut), 995), Constants.CHARSET));
    }

    public void start(int totalTasks) {
        this.lastOutput = this.taskBeganAt = System.currentTimeMillis();
    }

    public void beginTask(String title, int total) {
        this.endTask();
        this.msg = title;
        this.lastWorked = 0;
        this.totalWork = total;
    }

    public void update(int completed) {
        if (this.msg == null) {
            return;
        }
        int cmp = this.lastWorked + completed;
        long now = System.currentTimeMillis();
        if (!this.output && now - this.taskBeganAt < 500L) {
            return;
        }
        if (this.totalWork == 0) {
            if (now - this.lastOutput >= 500L) {
                this.display(cmp, null);
                this.lastOutput = now;
            }
        } else if (cmp * 100 / this.totalWork != this.lastWorked * 100 / this.totalWork || now - this.lastOutput >= 500L) {
            this.display(cmp, null);
            this.lastOutput = now;
        }
        this.lastWorked = cmp;
        this.output = true;
    }

    private void display(int cmp, String eol) {
        StringBuilder m = new StringBuilder();
        m.append(this.msg);
        m.append(": ");
        if (this.totalWork == 0) {
            m.append(cmp);
        } else {
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append(cmp);
            m.append("/");
            m.append(this.totalWork);
            m.append(")");
        }
        if (eol != null) {
            m.append(eol);
        } else {
            m.append("   \r");
        }
        this.out.print(m);
        this.out.flush();
    }

    public boolean isCancelled() {
        return false;
    }

    public void endTask() {
        if (this.output) {
            if (this.totalWork == 0) {
                this.display(this.lastWorked, ", done\n");
            } else {
                this.display(this.totalWork, "\n");
            }
        }
        this.output = false;
        this.msg = null;
    }
}

