/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.spearce.jgit.errors.MissingBundlePrerequisiteException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.BaseFetchConnection;
import org.spearce.jgit.transport.IndexPack;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.URIish;
import org.spearce.jgit.util.RawParseUtils;

abstract class TransportBundle
extends PackTransport {
    static final String V2_BUNDLE_SIGNATURE = "# v2 git bundle";

    TransportBundle(Repository local, URIish uri) {
        super(local, uri);
    }

    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException("Push is not supported for bundle transport");
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BundleFetchConnection
    extends BaseFetchConnection {
        InputStream bin;
        final Set<ObjectId> prereqs = new HashSet<ObjectId>();

        BundleFetchConnection(InputStream src) throws TransportException {
            this.bin = new BufferedInputStream(src, 8192);
            try {
                switch (this.readSignature()) {
                    case 2: {
                        this.readBundleV2();
                        break;
                    }
                    default: {
                        throw new TransportException(TransportBundle.this.uri, "not a bundle");
                    }
                }
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(TransportBundle.this.uri, err.getMessage(), err);
            }
            catch (RuntimeException err) {
                this.close();
                throw new TransportException(TransportBundle.this.uri, err.getMessage(), err);
            }
        }

        private int readSignature() throws IOException {
            String rev = this.readLine(new byte[1024]);
            if (TransportBundle.V2_BUNDLE_SIGNATURE.equals(rev)) {
                return 2;
            }
            throw new TransportException(TransportBundle.this.uri, "not a bundle");
        }

        private void readBundleV2() throws IOException {
            String line;
            byte[] hdrbuf = new byte[1024];
            LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
            while ((line = this.readLine(hdrbuf)).length() != 0) {
                ObjectId id;
                if (line.charAt(0) == '-') {
                    this.prereqs.add(ObjectId.fromString(line.substring(1, 41)));
                    continue;
                }
                String name = line.substring(41, line.length());
                Ref prior = avail.put(name, new Ref(Ref.Storage.NETWORK, name, id = ObjectId.fromString(line.substring(0, 40))));
                if (prior == null) continue;
                throw this.duplicateAdvertisement(name);
            }
            this.available(avail);
        }

        private PackProtocolException duplicateAdvertisement(String name) {
            return new PackProtocolException(TransportBundle.this.uri, "duplicate advertisements of " + name);
        }

        private String readLine(byte[] hdrbuf) throws IOException {
            int lf;
            this.bin.mark(hdrbuf.length);
            int cnt = this.bin.read(hdrbuf);
            for (lf = 0; lf < cnt && hdrbuf[lf] != 10; ++lf) {
            }
            this.bin.reset();
            this.bin.skip(lf);
            if (lf < cnt && hdrbuf[lf] == 10) {
                this.bin.skip(1L);
            }
            return RawParseUtils.decode(Constants.CHARSET, hdrbuf, 0, lf);
        }

        @Override
        public boolean didFetchTestConnectivity() {
            return false;
        }

        @Override
        protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
            this.verifyPrerequisites();
            try {
                IndexPack ip = this.newIndexPack();
                ip.index(monitor);
                ip.renameAndOpenPack();
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(TransportBundle.this.uri, err.getMessage(), err);
            }
            catch (RuntimeException err) {
                this.close();
                throw new TransportException(TransportBundle.this.uri, err.getMessage(), err);
            }
        }

        private IndexPack newIndexPack() throws IOException {
            IndexPack ip = IndexPack.create(TransportBundle.this.local, this.bin);
            ip.setFixThin(true);
            ip.setObjectChecking(TransportBundle.this.isCheckFetchedObjects());
            return ip;
        }

        private void verifyPrerequisites() throws TransportException {
            if (this.prereqs.isEmpty()) {
                return;
            }
            RevWalk rw = new RevWalk(TransportBundle.this.local);
            RevFlag PREREQ = rw.newFlag("PREREQ");
            RevFlag SEEN = rw.newFlag("SEEN");
            ArrayList<ObjectId> missing = new ArrayList<ObjectId>();
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (ObjectId p : this.prereqs) {
                try {
                    RevCommit revCommit = rw.parseCommit(p);
                    if (revCommit.has(PREREQ)) continue;
                    revCommit.add(PREREQ);
                    commits.add(revCommit);
                }
                catch (MissingObjectException missingObjectException) {
                    missing.add(p);
                }
                catch (IOException iOException) {
                    throw new TransportException(TransportBundle.this.uri, "Cannot read commit " + p.name(), iOException);
                }
            }
            if (!missing.isEmpty()) {
                throw new MissingBundlePrerequisiteException(TransportBundle.this.uri, missing);
            }
            for (Ref r : TransportBundle.this.local.getAllRefs().values()) {
                try {
                    rw.markStart(rw.parseCommit(r.getObjectId()));
                }
                catch (IOException iOException) {}
            }
            int remaining = commits.size();
            try {
                RevCommit c;
                while ((c = rw.next()) != null) {
                    if (!c.has(PREREQ)) continue;
                    c.add(SEEN);
                    if (--remaining != 0) continue;
                    break;
                }
            }
            catch (IOException err) {
                throw new TransportException(TransportBundle.this.uri, "Cannot read object", err);
            }
            if (remaining > 0) {
                for (RevObject revObject : commits) {
                    if (revObject.has(SEEN)) continue;
                    missing.add(revObject);
                }
                throw new MissingBundlePrerequisiteException(TransportBundle.this.uri, missing);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.bin != null) {
                try {
                    this.bin.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.bin = null;
                }
            }
        }
    }
}

