/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.FetchConnection;
import org.spearce.jgit.transport.TransportBundle;
import org.spearce.jgit.transport.URIish;
import org.spearce.jgit.util.FS;

class TransportBundleFile
extends TransportBundle {
    private final File bundle;

    static boolean canHandle(URIish uri) {
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            File f = FS.resolve(new File("."), uri.getPath());
            return f.isFile() || f.getName().endsWith(".bundle");
        }
        return false;
    }

    TransportBundleFile(Repository local, URIish uri) {
        super(local, uri);
        this.bundle = FS.resolve(new File("."), uri.getPath()).getAbsoluteFile();
    }

    public FetchConnection openFetch() throws NotSupportedException, TransportException {
        FileInputStream src;
        try {
            src = new FileInputStream(this.bundle);
        }
        catch (FileNotFoundException err) {
            throw new TransportException(this.uri, "not found");
        }
        return new TransportBundle.BundleFetchConnection(src);
    }
}

