/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.BasePackFetchConnection;
import org.spearce.jgit.transport.BasePackPushConnection;
import org.spearce.jgit.transport.FetchConnection;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PacketLineOut;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.URIish;

class TransportGitAnon
extends PackTransport {
    static final int GIT_PORT = 9418;

    static boolean canHandle(URIish uri) {
        return "git".equals(uri.getScheme());
    }

    TransportGitAnon(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        return new TcpFetchConnection();
    }

    public PushConnection openPush() throws TransportException {
        return new TcpPushConnection();
    }

    public void close() {
    }

    Socket openConnection() throws TransportException {
        int port = this.uri.getPort() > 0 ? this.uri.getPort() : 9418;
        try {
            return new Socket(InetAddress.getByName(this.uri.getHost()), port);
        }
        catch (IOException c) {
            if (c instanceof UnknownHostException) {
                throw new TransportException(this.uri, "unknown host");
            }
            if (c instanceof ConnectException) {
                throw new TransportException(this.uri, c.getMessage());
            }
            throw new TransportException(this.uri, c.getMessage(), c);
        }
    }

    void service(String name, PacketLineOut pckOut) throws IOException {
        StringBuilder cmd = new StringBuilder();
        cmd.append(name);
        cmd.append(' ');
        cmd.append(this.uri.getPath());
        cmd.append('\u0000');
        cmd.append("host=");
        cmd.append(this.uri.getHost());
        cmd.append('\u0000');
        pckOut.writeString(cmd.toString());
        pckOut.flush();
    }

    class TcpPushConnection
    extends BasePackPushConnection {
        private Socket sock;

        TcpPushConnection() throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                this.init(this.sock.getInputStream(), this.sock.getOutputStream());
                TransportGitAnon.this.service("git-receive-pack", this.pckOut);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.sock = null;
                }
            }
        }
    }

    class TcpFetchConnection
    extends BasePackFetchConnection {
        private Socket sock;

        TcpFetchConnection() throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                this.init(this.sock.getInputStream(), this.sock.getOutputStream());
                TransportGitAnon.this.service("git-upload-pack", this.pckOut);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.sock = null;
                }
            }
        }
    }
}

