/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.spearce.jgit.errors.NoRemoteRepositoryException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.BasePackFetchConnection;
import org.spearce.jgit.transport.BasePackPushConnection;
import org.spearce.jgit.transport.FetchConnection;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.SshSessionFactory;
import org.spearce.jgit.transport.URIish;
import org.spearce.jgit.util.QuotedString;

class TransportGitSsh
extends PackTransport {
    private final SshSessionFactory sch = SshSessionFactory.getInstance();
    private Session sock;
    OutputStream errStream;

    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String scheme = uri.getScheme();
        if ("ssh".equals(scheme)) {
            return true;
        }
        if ("ssh+git".equals(scheme)) {
            return true;
        }
        if ("git+ssh".equals(scheme)) {
            return true;
        }
        return scheme == null && uri.getHost() != null && uri.getPath() != null;
    }

    TransportGitSsh(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        return new SshFetchConnection();
    }

    public PushConnection openPush() throws TransportException {
        return new SshPushConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sock != null) {
            try {
                this.sch.releaseSession(this.sock);
            }
            finally {
                this.sock = null;
            }
        }
    }

    private static void sqMinimal(StringBuilder cmd, String val) {
        if (val.matches("^[a-zA-Z0-9._/-]*$")) {
            cmd.append(val);
        } else {
            TransportGitSsh.sq(cmd, val);
        }
    }

    private static void sqAlways(StringBuilder cmd, String val) {
        TransportGitSsh.sq(cmd, val);
    }

    private static void sq(StringBuilder cmd, String val) {
        if (val.length() > 0) {
            cmd.append(QuotedString.BOURNE.quote(val));
        }
    }

    private void initSession() throws TransportException {
        if (this.sock != null) {
            return;
        }
        String user = this.uri.getUser();
        String pass = this.uri.getPass();
        String host = this.uri.getHost();
        int port = this.uri.getPort();
        try {
            this.sock = this.sch.getSession(user, pass, host, port);
            if (!this.sock.isConnected()) {
                this.sock.connect();
            }
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(this.uri, "unknown host");
            }
            if (c instanceof ConnectException) {
                throw new TransportException(this.uri, c.getMessage());
            }
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    ChannelExec exec(String exe) throws TransportException {
        this.initSession();
        try {
            ChannelExec channel = (ChannelExec)this.sock.openChannel("exec");
            String path = this.uri.getPath();
            if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
                path = this.uri.getPath().substring(1);
            }
            StringBuilder cmd = new StringBuilder();
            int gitspace = exe.indexOf("git ");
            if (gitspace >= 0) {
                TransportGitSsh.sqMinimal(cmd, exe.substring(0, gitspace + 3));
                cmd.append(' ');
                TransportGitSsh.sqMinimal(cmd, exe.substring(gitspace + 4));
            } else {
                TransportGitSsh.sqMinimal(cmd, exe);
            }
            cmd.append(' ');
            TransportGitSsh.sqAlways(cmd, path);
            channel.setCommand(cmd.toString());
            this.errStream = SshSessionFactory.getInstance().getErrorStream();
            channel.setErrStream(this.errStream, true);
            channel.connect();
            return channel;
        }
        catch (JSchException je) {
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException nf) {
        String why = this.errStream.toString();
        if (why == null || why.length() == 0) {
            return nf;
        }
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder pfx = new StringBuilder();
        pfx.append("fatal: ");
        TransportGitSsh.sqAlways(pfx, path);
        pfx.append(": ");
        if (why.startsWith(pfx.toString())) {
            why = why.substring(pfx.length());
        }
        return new NoRemoteRepositoryException(this.uri, why);
    }

    class SshPushConnection
    extends BasePackPushConnection {
        private ChannelExec channel;

        SshPushConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.channel = TransportGitSsh.this.exec(TransportGitSsh.this.getOptionReceivePack());
                if (!this.channel.isConnected()) {
                    throw new TransportException(this.uri, TransportGitSsh.this.errStream.toString());
                }
                this.init(this.channel.getInputStream(), this.channel.getOutputStream());
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                throw TransportGitSsh.this.cleanNotFound(notFound);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.channel != null) {
                try {
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                }
                finally {
                    this.channel = null;
                }
            }
        }
    }

    class SshFetchConnection
    extends BasePackFetchConnection {
        private ChannelExec channel;

        SshFetchConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.channel = TransportGitSsh.this.exec(TransportGitSsh.this.getOptionUploadPack());
                if (!this.channel.isConnected()) {
                    throw new TransportException(this.uri, TransportGitSsh.this.errStream.toString());
                }
                this.init(this.channel.getInputStream(), this.channel.getOutputStream());
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                throw TransportGitSsh.this.cleanNotFound(notFound);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.channel != null) {
                try {
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                }
                finally {
                    this.channel = null;
                }
            }
        }
    }
}

