/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.errors.TransportException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.transport.BasePackFetchConnection;
import org.spearce.jgit.transport.BasePackPushConnection;
import org.spearce.jgit.transport.FetchConnection;
import org.spearce.jgit.transport.PackTransport;
import org.spearce.jgit.transport.PushConnection;
import org.spearce.jgit.transport.ReceivePack;
import org.spearce.jgit.transport.URIish;
import org.spearce.jgit.transport.UploadPack;
import org.spearce.jgit.util.FS;

class TransportLocal
extends PackTransport {
    private static final String PWD = ".";
    private final File remoteGitDir;

    static boolean canHandle(URIish uri) {
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            return FS.resolve(new File(PWD), uri.getPath()).isDirectory();
        }
        return false;
    }

    TransportLocal(Repository local, URIish uri) {
        super(local, uri);
        File d = FS.resolve(new File(PWD), uri.getPath()).getAbsoluteFile();
        if (new File(d, ".git").isDirectory()) {
            d = new File(d, ".git");
        }
        this.remoteGitDir = d;
    }

    public FetchConnection openFetch() throws TransportException {
        String up = this.getOptionUploadPack();
        if ("git-upload-pack".equals(up) || "git upload-pack".equals(up)) {
            return new InternalLocalFetchConnection();
        }
        return new ForkLocalFetchConnection();
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        String rp = this.getOptionReceivePack();
        if ("git-receive-pack".equals(rp) || "git receive-pack".equals(rp)) {
            return new InternalLocalPushConnection();
        }
        return new ForkLocalPushConnection();
    }

    public void close() {
    }

    protected Process startProcessWithErrStream(String cmd) throws TransportException {
        try {
            String[] args;
            if (cmd.startsWith("git-")) {
                args = new String[]{"git", cmd.substring(4), PWD};
            } else {
                int gitspace = cmd.indexOf("git ");
                if (gitspace >= 0) {
                    String git = cmd.substring(0, gitspace + 3);
                    String subcmd = cmd.substring(gitspace + 4);
                    args = new String[]{git, subcmd, PWD};
                } else {
                    args = new String[]{cmd, PWD};
                }
            }
            Process proc = Runtime.getRuntime().exec(args, null, this.remoteGitDir);
            new StreamRewritingThread(cmd, proc.getErrorStream()).start();
            return proc;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    class StreamRewritingThread
    extends Thread {
        private final InputStream in;

        StreamRewritingThread(String cmd, InputStream in) {
            super("JGit " + cmd + " Errors");
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] tmp = new byte[512];
            try {
                int n;
                while ((n = this.in.read(tmp)) >= 0) {
                    System.err.write(tmp, 0, n);
                    System.err.flush();
                }
            }
            catch (IOException err) {
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException err2) {}
            }
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            this.receivePack = TransportLocal.this.startProcessWithErrStream(TransportLocal.this.getOptionReceivePack());
            this.init(this.receivePack.getInputStream(), this.receivePack.getOutputStream());
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    this.receivePack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.receivePack = null;
                }
            }
        }
    }

    class InternalLocalPushConnection
    extends BasePackPushConnection {
        private Thread worker;

        InternalLocalPushConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Repository dst;
            super(TransportLocal.this);
            try {
                dst = new Repository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, "not a git directory");
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream();
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, "cannot connect pipes", err);
            }
            this.worker = new Thread("JGit-Receive-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ReceivePack rp = new ReceivePack(dst);
                        rp.receive(out_r, in_w, System.err);
                    }
                    catch (IOException err) {
                    }
                    catch (RuntimeException err) {
                    }
                    finally {
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {}
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {}
                        dst.close();
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.worker = null;
                }
            }
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;

        ForkLocalFetchConnection() throws TransportException {
            super(TransportLocal.this);
            this.uploadPack = TransportLocal.this.startProcessWithErrStream(TransportLocal.this.getOptionUploadPack());
            this.init(this.uploadPack.getInputStream(), this.uploadPack.getOutputStream());
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    this.uploadPack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.uploadPack = null;
                }
            }
        }
    }

    class InternalLocalFetchConnection
    extends BasePackFetchConnection {
        private Thread worker;

        InternalLocalFetchConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Repository dst;
            super(TransportLocal.this);
            try {
                dst = new Repository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, "not a git directory");
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream(){
                    {
                        this.buffer = new byte[12800];
                    }
                };
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, "cannot connect pipes", err);
            }
            this.worker = new Thread("JGit-Upload-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        UploadPack rp = new UploadPack(dst);
                        rp.upload(out_r, in_w, null);
                    }
                    catch (IOException err) {
                        err.printStackTrace();
                    }
                    catch (RuntimeException err) {
                        err.printStackTrace();
                    }
                    finally {
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {}
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {}
                        dst.close();
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.worker = null;
                }
            }
        }
    }
}

