/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIish
implements Externalizable {
    private static final Pattern FULL_URI = Pattern.compile("^(?:([a-z][a-z0-9+-]+)://(?:([^/]+?)(?::([^/]+?))?@)?(?:([^/]+?))?(?::(\\d+))?)?((?:[A-Za-z]:)?/.+)$");
    private static final Pattern SCP_URI = Pattern.compile("^(?:([^@]+?)@)?([^:]+?):(.+)$");
    private String scheme;
    private String path;
    private String user;
    private String pass;
    private int port = -1;
    private String host;

    public URIish(String s) throws URISyntaxException {
        this.initializeFromString(s);
    }

    private void initializeFromString(String s) throws URISyntaxException {
        Matcher matcher = FULL_URI.matcher(s = s.replace('\\', '/'));
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.user = matcher.group(2);
            this.pass = matcher.group(3);
            this.host = matcher.group(4);
            if (matcher.group(5) != null) {
                this.port = Integer.parseInt(matcher.group(5));
            }
            this.path = matcher.group(6);
            if (this.path.length() >= 3 && this.path.charAt(0) == '/' && this.path.charAt(2) == ':' && (this.path.charAt(1) >= 'A' && this.path.charAt(1) <= 'Z' || this.path.charAt(1) >= 'a' && this.path.charAt(1) <= 'z')) {
                this.path = this.path.substring(1);
            }
        } else {
            matcher = SCP_URI.matcher(s);
            if (matcher.matches()) {
                this.user = matcher.group(1);
                this.host = matcher.group(2);
                this.path = matcher.group(3);
            } else {
                throw new URISyntaxException(s, "Cannot parse Git URI-ish");
            }
        }
    }

    public URIish(URL u) {
        this.scheme = u.getProtocol();
        this.path = u.getPath();
        String ui = u.getUserInfo();
        if (ui != null) {
            int d = ui.indexOf(58);
            this.user = d < 0 ? ui : ui.substring(0, d);
            this.pass = d < 0 ? null : ui.substring(d + 1);
        }
        this.port = u.getPort();
        this.host = u.getHost();
    }

    public URIish() {
    }

    private URIish(URIish u) {
        this.scheme = u.scheme;
        this.path = u.path;
        this.user = u.user;
        this.pass = u.pass;
        this.port = u.port;
        this.host = u.host;
    }

    public boolean isRemote() {
        return this.getHost() != null;
    }

    public String getHost() {
        return this.host;
    }

    public URIish setHost(String n) {
        URIish r = new URIish(this);
        r.host = n;
        return r;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URIish setScheme(String n) {
        URIish r = new URIish(this);
        r.scheme = n;
        return r;
    }

    public String getPath() {
        return this.path;
    }

    public URIish setPath(String n) {
        URIish r = new URIish(this);
        r.path = n;
        return r;
    }

    public String getUser() {
        return this.user;
    }

    public URIish setUser(String n) {
        URIish r = new URIish(this);
        r.user = n;
        return r;
    }

    public String getPass() {
        return this.pass;
    }

    public URIish setPass(String n) {
        URIish r = new URIish(this);
        r.pass = n;
        return r;
    }

    public int getPort() {
        return this.port;
    }

    public URIish setPort(int n) {
        URIish r = new URIish(this);
        r.port = n > 0 ? n : -1;
        return r;
    }

    public int hashCode() {
        int hc = 0;
        if (this.getScheme() != null) {
            hc = hc * 31 + this.getScheme().hashCode();
        }
        if (this.getUser() != null) {
            hc = hc * 31 + this.getUser().hashCode();
        }
        if (this.getPass() != null) {
            hc = hc * 31 + this.getPass().hashCode();
        }
        if (this.getHost() != null) {
            hc = hc * 31 + this.getHost().hashCode();
        }
        if (this.getPort() > 0) {
            hc = hc * 31 + this.getPort();
        }
        if (this.getPath() != null) {
            hc = hc * 31 + this.getPath().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URIish)) {
            return false;
        }
        URIish b = (URIish)obj;
        if (!URIish.eq(this.getScheme(), b.getScheme())) {
            return false;
        }
        if (!URIish.eq(this.getUser(), b.getUser())) {
            return false;
        }
        if (!URIish.eq(this.getPass(), b.getPass())) {
            return false;
        }
        if (!URIish.eq(this.getHost(), b.getHost())) {
            return false;
        }
        if (this.getPort() != b.getPort()) {
            return false;
        }
        return URIish.eq(this.getPath(), b.getPath());
    }

    private static boolean eq(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toPrivateString() {
        return this.format(true);
    }

    public String toString() {
        return this.format(false);
    }

    private String format(boolean includePassword) {
        StringBuilder r = new StringBuilder();
        if (this.getScheme() != null) {
            r.append(this.getScheme());
            r.append("://");
        }
        if (this.getUser() != null) {
            r.append(this.getUser());
            if (includePassword && this.getPass() != null) {
                r.append(':');
                r.append(this.getPass());
            }
        }
        if (this.getHost() != null) {
            if (this.getUser() != null) {
                r.append('@');
            }
            r.append(this.getHost());
            if (this.getScheme() != null && this.getPort() > 0) {
                r.append(':');
                r.append(this.getPort());
            }
        }
        if (this.getPath() != null) {
            if (this.getScheme() != null) {
                if (!this.getPath().startsWith("/")) {
                    r.append('/');
                }
            } else if (this.getHost() != null) {
                r.append(':');
            }
            r.append(this.getPath());
        }
        return r.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.initializeFromString(in.readUTF());
        }
        catch (URISyntaxException e) {
            throw new IOException("Incorrect format URI");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.format(true));
    }
}

