/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spearce.jgit.errors.PackProtocolException;
import org.spearce.jgit.lib.NullProgressMonitor;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackWriter;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefComparator;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevFlagSet;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevTag;
import org.spearce.jgit.revwalk.RevWalk;
import org.spearce.jgit.transport.PacketLineIn;
import org.spearce.jgit.transport.PacketLineOut;
import org.spearce.jgit.transport.SideBandOutputStream;
import org.spearce.jgit.transport.SideBandProgressMonitor;

public class UploadPack {
    static final String OPTION_INCLUDE_TAG = "include-tag";
    static final String OPTION_MULTI_ACK = "multi_ack";
    static final String OPTION_THIN_PACK = "thin-pack";
    static final String OPTION_SIDE_BAND = "side-band";
    static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    static final String OPTION_OFS_DELTA = "ofs-delta";
    static final String OPTION_NO_PROGRESS = "no-progress";
    private final Repository db;
    private final RevWalk walk;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private Map<String, Ref> refs;
    private final Set<String> options = new HashSet<String>();
    private final List<RevObject> wantAll = new ArrayList<RevObject>();
    private final List<RevCommit> wantCommits = new ArrayList<RevCommit>();
    private final List<RevObject> commonBase = new ArrayList<RevObject>();
    private final RevFlag ADVERTISED;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlagSet SAVE;
    private boolean multiAck;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.ADVERTISED = this.walk.newFlag("ADVERTISED");
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.ADVERTISED);
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public void upload(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        this.rawIn = input;
        this.rawOut = output;
        this.pckIn = new PacketLineIn(this.rawIn);
        this.pckOut = new PacketLineOut(this.rawOut);
        this.service();
    }

    private void service() throws IOException {
        this.sendAdvertisedRefs();
        this.recvWants();
        if (this.wantAll.isEmpty()) {
            return;
        }
        this.multiAck = this.options.contains(OPTION_MULTI_ACK);
        this.negotiate();
        this.sendPack();
    }

    private void sendAdvertisedRefs() throws IOException {
        Ref r;
        RevObject o;
        this.refs = this.db.getAllRefs();
        StringBuilder m = new StringBuilder(100);
        char[] idtmp = new char[40];
        Iterator<Ref> i = RefComparator.sort(this.refs.values()).iterator();
        if (i.hasNext() && (o = this.safeParseAny((r = i.next()).getObjectId())) != null) {
            this.advertise(m, idtmp, o, r.getOrigName());
            m.append('\u0000');
            m.append(' ');
            m.append(OPTION_INCLUDE_TAG);
            m.append(' ');
            m.append(OPTION_MULTI_ACK);
            m.append(' ');
            m.append(OPTION_OFS_DELTA);
            m.append(' ');
            m.append(OPTION_SIDE_BAND);
            m.append(' ');
            m.append(OPTION_SIDE_BAND_64K);
            m.append(' ');
            m.append(OPTION_THIN_PACK);
            m.append(' ');
            m.append(OPTION_NO_PROGRESS);
            m.append(' ');
            this.writeAdvertisedRef(m);
            if (o instanceof RevTag) {
                this.writeAdvertisedTag(m, idtmp, o, r.getName());
            }
        }
        while (i.hasNext()) {
            r = i.next();
            o = this.safeParseAny(r.getObjectId());
            if (o == null) continue;
            this.advertise(m, idtmp, o, r.getOrigName());
            this.writeAdvertisedRef(m);
            if (!(o instanceof RevTag)) continue;
            this.writeAdvertisedTag(m, idtmp, o, r.getName());
        }
        this.pckOut.end();
    }

    private RevObject safeParseAny(ObjectId id) {
        try {
            return this.walk.parseAny(id);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void advertise(StringBuilder m, char[] idtmp, RevObject o, String name) {
        o.add(this.ADVERTISED);
        m.setLength(0);
        o.getId().copyTo(idtmp, m);
        m.append(' ');
        m.append(name);
    }

    private void writeAdvertisedRef(StringBuilder m) throws IOException {
        m.append('\n');
        this.pckOut.writeString(m.toString());
    }

    private void writeAdvertisedTag(StringBuilder m, char[] idtmp, RevObject tag, String name) throws IOException {
        RevObject o = tag;
        while (o instanceof RevTag) {
            try {
                this.walk.parse(((RevTag)o).getObject());
            }
            catch (IOException err) {
                return;
            }
            o = ((RevTag)o).getObject();
            o.add(this.ADVERTISED);
        }
        this.advertise(m, idtmp, ((RevTag)tag).getObject(), name + "^{}");
        this.writeAdvertisedRef(m);
    }

    private void recvWants() throws IOException {
        boolean isFirst = true;
        while (true) {
            RevObject o;
            int sp;
            String line;
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line.length() == 0) break;
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException("expected want; got " + line);
            }
            if (isFirst && (sp = line.indexOf(32, 45)) >= 0) {
                for (String c : line.substring(sp + 1).split(" ")) {
                    this.options.add(c);
                }
                line = line.substring(0, sp);
            }
            ObjectId id = ObjectId.fromString(line.substring(5));
            try {
                o = this.walk.parseAny(id);
            }
            catch (IOException e) {
                throw new PackProtocolException(id.name() + " not valid", e);
            }
            if (!o.has(this.ADVERTISED)) {
                throw new PackProtocolException(id.name() + " not valid");
            }
            this.want(o);
            isFirst = false;
        }
    }

    private void want(RevObject o) {
        if (!o.has(this.WANT)) {
            o.add(this.WANT);
            this.wantAll.add(o);
            if (o instanceof RevCommit) {
                this.wantCommits.add((RevCommit)o);
            } else if (o instanceof RevTag) {
                while ((o = ((RevTag)o).getObject()) instanceof RevTag) {
                }
                if (o instanceof RevCommit) {
                    this.want(o);
                }
            }
        }
    }

    private void negotiate() throws IOException {
        String line;
        ObjectId last = ObjectId.zeroId();
        while (true) {
            line = this.pckIn.readString();
            if (line.length() == 0) {
                if (!this.commonBase.isEmpty() && !this.multiAck) continue;
                this.pckOut.writeString("NAK\n");
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            ObjectId id = ObjectId.fromString(line.substring(5));
            if (this.matchHave(id)) {
                if (this.multiAck) {
                    last = id;
                    this.pckOut.writeString("ACK " + id.name() + " continue\n");
                    continue;
                }
                if (this.commonBase.size() != 1) continue;
                this.pckOut.writeString("ACK " + id.name() + "\n");
                continue;
            }
            if (!this.multiAck || !this.okToGiveUp()) continue;
            this.pckOut.writeString("ACK " + id.name() + " continue\n");
        }
        if (line.equals("done")) {
            if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            } else if (this.multiAck) {
                this.pckOut.writeString("ACK " + last.name() + "\n");
            }
        } else {
            throw new PackProtocolException("expected have; got " + line);
        }
    }

    private boolean matchHave(ObjectId id) {
        RevObject o;
        try {
            o = this.walk.parseAny(id);
        }
        catch (IOException err) {
            return false;
        }
        if (!o.has(this.PEER_HAS)) {
            o.add(this.PEER_HAS);
            if (o instanceof RevCommit) {
                ((RevCommit)o).carry(this.PEER_HAS);
            }
            if (!o.has(this.COMMON)) {
                o.add(this.COMMON);
                this.commonBase.add(o);
            }
        }
        return true;
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            Iterator<RevCommit> i = this.wantCommits.iterator();
            while (i.hasNext()) {
                RevCommit want = i.next();
                if (!this.wantSatisfied(want)) continue;
                i.remove();
            }
        }
        catch (IOException e) {
            throw new PackProtocolException("internal revision error", e);
        }
        return this.wantCommits.isEmpty();
    }

    private boolean wantSatisfied(RevCommit want) throws IOException {
        RevCommit c;
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart(want);
        while ((c = this.walk.next()) != null) {
            if (c.has(this.PEER_HAS)) {
                if (!c.has(this.COMMON)) {
                    c.add(this.COMMON);
                    this.commonBase.add(c);
                }
                return true;
            }
            c.dispose();
        }
        return false;
    }

    private void sendPack() throws IOException {
        boolean thin = this.options.contains(OPTION_THIN_PACK);
        boolean progress = !this.options.contains(OPTION_NO_PROGRESS);
        boolean sideband = this.options.contains(OPTION_SIDE_BAND) || this.options.contains(OPTION_SIDE_BAND_64K);
        ProgressMonitor pm = NullProgressMonitor.INSTANCE;
        OutputStream packOut = this.rawOut;
        if (sideband) {
            int bufsz = 1000;
            if (this.options.contains(OPTION_SIDE_BAND_64K)) {
                bufsz = 65520;
            }
            packOut = new BufferedOutputStream(new SideBandOutputStream(1, this.pckOut), bufsz -= 5);
            if (progress) {
                pm = new SideBandProgressMonitor(this.pckOut);
            }
        }
        PackWriter pw = new PackWriter(this.db, pm, NullProgressMonitor.INSTANCE);
        pw.setDeltaBaseAsOffset(this.options.contains(OPTION_OFS_DELTA));
        pw.preparePack(this.wantAll, this.commonBase, thin, true);
        if (this.options.contains(OPTION_INCLUDE_TAG)) {
            for (Ref r : this.refs.values()) {
                RevTag t;
                RevObject o;
                try {
                    o = this.walk.parseAny(r.getObjectId());
                }
                catch (IOException e) {
                    continue;
                }
                if (o.has(this.WANT) || !(o instanceof RevTag) || pw.willInclude(t = (RevTag)o) || !pw.willInclude(t.getObject())) continue;
                pw.addObject(t);
            }
        }
        pw.writePack(packOut);
        if (sideband) {
            packOut.flush();
            this.pckOut.end();
        } else {
            this.rawOut.flush();
        }
    }
}

