/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.treewalk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.MutableObjectId;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.treewalk.TreeWalk;

public abstract class AbstractTreeIterator {
    static final int DEFAULT_PATH_SIZE = 128;
    protected static final byte[] zeroid = new byte[20];
    final AbstractTreeIterator parent;
    AbstractTreeIterator matches;
    int matchShift;
    protected int mode;
    protected byte[] path;
    protected final int pathOffset;
    protected int pathLen;

    protected AbstractTreeIterator() {
        this.parent = null;
        this.path = new byte[128];
        this.pathOffset = 0;
    }

    protected AbstractTreeIterator(String prefix) {
        this.parent = null;
        if (prefix != null && prefix.length() > 0) {
            ByteBuffer b = Constants.CHARSET.encode(CharBuffer.wrap(prefix));
            this.pathLen = b.limit();
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            b.get(this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(byte[] prefix) {
        this.parent = null;
        if (prefix != null && prefix.length > 0) {
            this.pathLen = prefix.length;
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            System.arraycopy(prefix, 0, this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(AbstractTreeIterator p) {
        this.parent = p;
        this.path = p.path;
        this.pathOffset = p.pathLen + 1;
        try {
            this.path[this.pathOffset - 1] = 47;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.growPath(p.pathLen);
            this.path[this.pathOffset - 1] = 47;
        }
    }

    protected AbstractTreeIterator(AbstractTreeIterator p, byte[] childPath, int childPathOffset) {
        this.parent = p;
        this.path = childPath;
        this.pathOffset = childPathOffset;
    }

    protected void growPath(int len) {
        byte[] n = new byte[this.path.length << 1];
        System.arraycopy(this.path, 0, n, 0, len);
        AbstractTreeIterator p = this;
        while (p != null) {
            p.path = n;
            p = p.parent;
        }
    }

    public int pathCompare(AbstractTreeIterator p) {
        return this.pathCompare(p, p.mode);
    }

    int pathCompare(AbstractTreeIterator p, int pMode) {
        int cPos;
        byte[] a = this.path;
        byte[] b = p.path;
        int aLen = this.pathLen;
        int bLen = p.pathLen;
        for (cPos = AbstractTreeIterator.alreadyMatch(this, p); cPos < aLen && cPos < bLen; ++cPos) {
            int cmp = (a[cPos] & 0xFF) - (b[cPos] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        if (cPos < aLen) {
            return (a[cPos] & 0xFF) - AbstractTreeIterator.lastPathChar(pMode);
        }
        if (cPos < bLen) {
            return AbstractTreeIterator.lastPathChar(this.mode) - (b[cPos] & 0xFF);
        }
        return AbstractTreeIterator.lastPathChar(this.mode) - AbstractTreeIterator.lastPathChar(pMode);
    }

    private static int alreadyMatch(AbstractTreeIterator a, AbstractTreeIterator b) {
        while (true) {
            AbstractTreeIterator ap = a.parent;
            AbstractTreeIterator bp = b.parent;
            if (ap == null || bp == null) {
                return 0;
            }
            if (ap.matches == bp.matches) {
                return a.pathOffset;
            }
            a = ap;
            b = bp;
        }
    }

    private static int lastPathChar(int mode) {
        return FileMode.TREE.equals(mode) ? 47 : 0;
    }

    public boolean idEqual(AbstractTreeIterator otherIterator) {
        return ObjectId.equals(this.idBuffer(), this.idOffset(), otherIterator.idBuffer(), otherIterator.idOffset());
    }

    public ObjectId getEntryObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void getEntryObjectId(MutableObjectId out) {
        out.fromRaw(this.idBuffer(), this.idOffset());
    }

    public FileMode getEntryFileMode() {
        return FileMode.fromBits(this.mode);
    }

    public String getEntryPathString() {
        return TreeWalk.pathOf(this);
    }

    public abstract byte[] idBuffer();

    public abstract int idOffset();

    public abstract AbstractTreeIterator createSubtreeIterator(Repository var1) throws IncorrectObjectTypeException, IOException;

    public AbstractTreeIterator createSubtreeIterator(Repository repo, MutableObjectId idBuffer, WindowCursor curs) throws IncorrectObjectTypeException, IOException {
        return this.createSubtreeIterator(repo);
    }

    public abstract boolean first();

    public abstract boolean eof();

    public abstract void next(int var1) throws CorruptObjectException;

    public abstract void back(int var1) throws CorruptObjectException;

    public void skip() throws CorruptObjectException {
        this.next(1);
    }

    public void stopWalk() {
    }
}

