/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.treewalk;

import java.io.IOException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.MutableObjectId;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.treewalk.AbstractTreeIterator;

public class CanonicalTreeParser
extends AbstractTreeIterator {
    private static final byte[] EMPTY = new byte[0];
    private byte[] raw;
    private int currPtr;
    private int nextPtr;

    public CanonicalTreeParser() {
        this.raw = EMPTY;
    }

    public CanonicalTreeParser(byte[] prefix, Repository repo, ObjectId treeId, WindowCursor curs) throws IncorrectObjectTypeException, IOException {
        super(prefix);
        this.reset(repo, treeId, curs);
    }

    private CanonicalTreeParser(CanonicalTreeParser p) {
        super(p);
    }

    public void reset(byte[] treeData) {
        this.raw = treeData;
        this.currPtr = 0;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    public CanonicalTreeParser resetRoot(Repository repo, AnyObjectId id, WindowCursor curs) throws IncorrectObjectTypeException, IOException {
        CanonicalTreeParser p = this;
        while (p.parent != null) {
            p = (CanonicalTreeParser)p.parent;
        }
        p.reset(repo, id, curs);
        return p;
    }

    public CanonicalTreeParser next() {
        this.next(1);
        return this.eof() && this.parent != null ? (CanonicalTreeParser)this.parent : this;
    }

    public void reset(Repository repo, AnyObjectId id, WindowCursor curs) throws IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = repo.openObject(curs, id);
        if (ldr == null) {
            ObjectId me = id.toObjectId();
            throw new MissingObjectException(me, "tree");
        }
        byte[] subtreeData = ldr.getCachedBytes();
        if (ldr.getType() != 2) {
            ObjectId me = id.toObjectId();
            throw new IncorrectObjectTypeException(me, "tree");
        }
        this.reset(subtreeData);
    }

    public CanonicalTreeParser createSubtreeIterator(Repository repo, MutableObjectId idBuffer, WindowCursor curs) throws IncorrectObjectTypeException, IOException {
        idBuffer.fromRaw(this.idBuffer(), this.idOffset());
        if (!FileMode.TREE.equals(this.mode)) {
            ObjectId me = idBuffer.toObjectId();
            throw new IncorrectObjectTypeException(me, "tree");
        }
        CanonicalTreeParser p = new CanonicalTreeParser(this);
        p.reset(repo, idBuffer, curs);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CanonicalTreeParser createSubtreeIterator(Repository repo) throws IncorrectObjectTypeException, IOException {
        WindowCursor curs = new WindowCursor();
        try {
            CanonicalTreeParser canonicalTreeParser = this.createSubtreeIterator(repo, new MutableObjectId(), curs);
            return canonicalTreeParser;
        }
        finally {
            curs.release();
        }
    }

    public byte[] idBuffer() {
        return this.raw;
    }

    public int idOffset() {
        return this.nextPtr - 20;
    }

    public boolean first() {
        return this.currPtr == 0;
    }

    public boolean eof() {
        return this.currPtr == this.raw.length;
    }

    public void next(int delta) {
        int ptr;
        if (delta == 1) {
            this.currPtr = this.nextPtr;
            if (!this.eof()) {
                this.parseEntry();
            }
            return;
        }
        int end = this.raw.length;
        for (ptr = this.nextPtr; --delta > 0 && ptr != end; ptr += 21) {
            while (this.raw[ptr] != 0) {
                ++ptr;
            }
        }
        if (delta != 0) {
            throw new ArrayIndexOutOfBoundsException(delta);
        }
        this.currPtr = ptr;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    public void back(int delta) {
        int ptr = this.currPtr;
        while (--delta >= 0) {
            int n;
            byte b;
            if (ptr == 0) {
                throw new ArrayIndexOutOfBoundsException(delta);
            }
            ptr -= 20;
            while (this.raw[--ptr] != 32) {
            }
            if (--ptr < 20) {
                if (delta != 0) {
                    throw new ArrayIndexOutOfBoundsException(delta);
                }
                ptr = 0;
                break;
            }
            while (48 <= (b = this.raw[n = ptr - 1]) && b <= 55 || this.raw[n - 20] != 0) {
                ptr = n;
            }
        }
        this.currPtr = ptr;
        this.parseEntry();
    }

    private void parseEntry() {
        int ptr = this.currPtr;
        byte c = this.raw[ptr++];
        int tmp = c - 48;
        while (32 != (c = this.raw[ptr++])) {
            tmp <<= 3;
            tmp += c - 48;
        }
        this.mode = tmp;
        tmp = this.pathOffset;
        while ((c = this.raw[ptr++]) != 0) {
            try {
                this.path[tmp] = c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.growPath(tmp);
                this.path[tmp] = c;
            }
            ++tmp;
        }
        this.pathLen = tmp;
        this.nextPtr = ptr + 20;
    }
}

