/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.treewalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.treewalk.AbstractTreeIterator;
import org.spearce.jgit.treewalk.WorkingTreeIterator;
import org.spearce.jgit.util.FS;

public class FileTreeIterator
extends WorkingTreeIterator {
    private final File directory;

    public FileTreeIterator(File root) {
        this.directory = root;
        this.init(this.entries());
    }

    protected FileTreeIterator(FileTreeIterator p, File root) {
        super(p);
        this.directory = root;
        this.init(this.entries());
    }

    public AbstractTreeIterator createSubtreeIterator(Repository repo) throws IncorrectObjectTypeException, IOException {
        return new FileTreeIterator(this, ((FileEntry)this.current()).file);
    }

    private WorkingTreeIterator.Entry[] entries() {
        File[] all = this.directory.listFiles();
        if (all == null) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new FileEntry(all[i]);
        }
        return r;
    }

    static class FileEntry
    extends WorkingTreeIterator.Entry {
        final File file;
        private final FileMode mode;
        private long length = -1L;
        private long lastModified;

        FileEntry(File f) {
            this.file = f;
            this.mode = f.isDirectory() ? (new File(f, ".git").isDirectory() ? FileMode.GITLINK : FileMode.TREE) : (FS.INSTANCE.canExecute(this.file) ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE);
        }

        public FileMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.file.getName();
        }

        public long getLength() {
            if (this.length < 0L) {
                this.length = this.file.length();
            }
            return this.length;
        }

        public long getLastModified() {
            if (this.lastModified == 0L) {
                this.lastModified = this.file.lastModified();
            }
            return this.lastModified;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

