/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.spearce.jgit.awtui.AwtAuthenticator;

public class HttpSupport {
    public static void configureHttpProxy() throws MalformedURLException {
        String userpass;
        String s = System.getenv("http_proxy");
        if (s == null || s.equals("")) {
            return;
        }
        URL u = new URL(s);
        if (!"http".equals(u.getProtocol())) {
            throw new MalformedURLException("Invalid http_proxy: " + s + ": Only http supported.");
        }
        String proxyHost = u.getHost();
        int proxyPort = u.getPort();
        System.setProperty("http.proxyHost", proxyHost);
        if (proxyPort > 0) {
            System.setProperty("http.proxyPort", String.valueOf(proxyPort));
        }
        if ((userpass = u.getUserInfo()) != null && userpass.contains(":")) {
            int c = userpass.indexOf(58);
            String user = userpass.substring(0, c);
            String pass = userpass.substring(c + 1);
            AwtAuthenticator.add(new AwtAuthenticator.CachedAuthentication(proxyHost, proxyPort, user, pass));
        }
    }

    public static void encode(StringBuilder urlstr, String key) {
        if (key == null || key.length() == 0) {
            return;
        }
        try {
            urlstr.append(URLEncoder.encode(key, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not URL encode to UTF-8", e);
        }
    }

    public static int response(HttpURLConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host = c.getURL().getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException("Connection time out: " + host);
            }
            throw new ConnectException(ce.getMessage() + " " + host);
        }
    }

    public static Proxy proxyFor(ProxySelector proxySelector, URL u) throws ConnectException {
        try {
            return proxySelector.select(u.toURI()).get(0);
        }
        catch (URISyntaxException e) {
            ConnectException err = new ConnectException("Cannot determine proxy for " + u);
            err.initCause(e);
            throw err;
        }
    }

    private HttpSupport() {
    }
}

